// Code generated by "esc -ignore \.go -prefix server -o server/static/static.go -pkg static server/static"; DO NOT EDIT.

package static

import (
	"bytes"
	"compress/gzip"
	"encoding/base64"
	"io/ioutil"
	"net/http"
	"os"
	"path"
	"sync"
	"time"
)

type _escLocalFS struct{}

var _escLocal _escLocalFS

type _escStaticFS struct{}

var _escStatic _escStaticFS

type _escDirectory struct {
	fs   http.FileSystem
	name string
}

type _escFile struct {
	compressed string
	size       int64
	modtime    int64
	local      string
	isDir      bool

	once sync.Once
	data []byte
	name string
}

func (_escLocalFS) Open(name string) (http.File, error) {
	f, present := _escData[path.Clean(name)]
	if !present {
		return nil, os.ErrNotExist
	}
	return os.Open(f.local)
}

func (_escStaticFS) prepare(name string) (*_escFile, error) {
	f, present := _escData[path.Clean(name)]
	if !present {
		return nil, os.ErrNotExist
	}
	var err error
	f.once.Do(func() {
		f.name = path.Base(name)
		if f.size == 0 {
			return
		}
		var gr *gzip.Reader
		b64 := base64.NewDecoder(base64.StdEncoding, bytes.NewBufferString(f.compressed))
		gr, err = gzip.NewReader(b64)
		if err != nil {
			return
		}
		f.data, err = ioutil.ReadAll(gr)
	})
	if err != nil {
		return nil, err
	}
	return f, nil
}

func (fs _escStaticFS) Open(name string) (http.File, error) {
	f, err := fs.prepare(name)
	if err != nil {
		return nil, err
	}
	return f.File()
}

func (dir _escDirectory) Open(name string) (http.File, error) {
	return dir.fs.Open(dir.name + name)
}

func (f *_escFile) File() (http.File, error) {
	type httpFile struct {
		*bytes.Reader
		*_escFile
	}
	return &httpFile{
		Reader:   bytes.NewReader(f.data),
		_escFile: f,
	}, nil
}

func (f *_escFile) Close() error {
	return nil
}

func (f *_escFile) Readdir(count int) ([]os.FileInfo, error) {
	return nil, nil
}

func (f *_escFile) Stat() (os.FileInfo, error) {
	return f, nil
}

func (f *_escFile) Name() string {
	return f.name
}

func (f *_escFile) Size() int64 {
	return f.size
}

func (f *_escFile) Mode() os.FileMode {
	return 0
}

func (f *_escFile) ModTime() time.Time {
	return time.Unix(f.modtime, 0)
}

func (f *_escFile) IsDir() bool {
	return f.isDir
}

func (f *_escFile) Sys() interface{} {
	return f
}

// FS returns a http.Filesystem for the embedded assets. If useLocal is true,
// the filesystem's contents are instead used.
func FS(useLocal bool) http.FileSystem {
	if useLocal {
		return _escLocal
	}
	return _escStatic
}

// Dir returns a http.Filesystem for the embedded assets on a given prefix dir.
// If useLocal is true, the filesystem's contents are instead used.
func Dir(useLocal bool, name string) http.FileSystem {
	if useLocal {
		return _escDirectory{fs: _escLocal, name: name}
	}
	return _escDirectory{fs: _escStatic, name: name}
}

// FSByte returns the named file from the embedded assets. If useLocal is
// true, the filesystem's contents are instead used.
func FSByte(useLocal bool, name string) ([]byte, error) {
	if useLocal {
		f, err := _escLocal.Open(name)
		if err != nil {
			return nil, err
		}
		b, err := ioutil.ReadAll(f)
		_ = f.Close()
		return b, err
	}
	f, err := _escStatic.prepare(name)
	if err != nil {
		return nil, err
	}
	return f.data, nil
}

// FSMustByte is the same as FSByte, but panics if name is not present.
func FSMustByte(useLocal bool, name string) []byte {
	b, err := FSByte(useLocal, name)
	if err != nil {
		panic(err)
	}
	return b
}

// FSString is the string version of FSByte.
func FSString(useLocal bool, name string) (string, error) {
	b, err := FSByte(useLocal, name)
	return string(b), err
}

// FSMustString is the string version of FSMustByte.
func FSMustString(useLocal bool, name string) string {
	return string(FSMustByte(useLocal, name))
}

var _escData = map[string]*_escFile{

	"/static/css/normalize.css": {
		local:   "server/static/css/normalize.css",
		size:    7797,
		modtime: 1508096488,
		compressed: `
H4sIAAAAAAAC/7RZaY/cNtL+rl9RcRDYnlfd0z2Ok7yazQcjxybI4UXsxS5gDCBKLHVzhyIFkurp9mb/
+6J46OjRTBxgnXyYtkRWFet46inq8uITUNq0TIr3uK6thcOL9WZ9Bb/DLz++hZ9Fjcoi/A474dZCXw5r
4eIyyy4vLjK4gO0a3qADjg3rpYNGKwcNa4U8gdNgmbIri0Y0a1p8tYa/GTygciBevwGHRweWBDL+r946
YI1DA9oIVI45oRXUe6Z2mMOdcHvdO+DCskoKtSNxANBbNPBe65bkX2bZ3rUS/p2BN2QVDCkmZlzD5QVs
aSnAqrUrMmFFJqyCCQVsN5vP/KqruOoOq1vh/nDlfwaX/IatPuDgkpaZnVDRvkrzk7cvPC1gcx12wg9v
f/n5JZ2vk+xEm4US5AKbAcDX/7P/prH7RhuDtYOykrq+LQflSrtgAHJotAGmTtE8lNj66Cn48Tv46vL/
139GTsnRMSFtCfQP27ctM6cyCttuLrdbksYUh++FwUYf/5z0lgk1SNtGhzPjRC0xz5gVHPMsmpBnjdjV
rCMP+9+9wTxrtHZo8myPjPu/O6P7Ls9Icp61qPo8U+yQZxbrsDMewoc0GlaAN/R6khHb9XgKoaRQuHrk
MHPnXq3h16HwDkjHYRKYFDvlQ6EbKDujdwat9af/Zm90i3nyYe4d+rpDw5JLei50ntVMHZjNs7Q5zw6C
o54fZWrttHaSIStvSAEVs0grl+ohlXyrORoFldF3Fo2Fxug2aRJqB6U3rBxqvdbKGS3telJUeKzRWtij
2O19GhKOvASOB1GjnR6wUNo9e5dk3Dyfn0tphdcZREFjGXqDX3FODoHy3V5wjuqmBOtOhDo+Tp1BOyuC
y+3G2/iD4Ahuj1A6bDvJHJb3K+Zyu83hDWuYEfk01+EvcHUVD5D05lkStGR9wI2fhbr9iBgR/U6n2hl2
gorVt1QVikOtpTYhiqx24oAgyZahnlM0vO3jvpXfV4AzTNmOGVRu6vwf286QRoOMs0pI4U5wt0cFja57
i9z7jEmrodW9RdjrA5pQNUzKIbuS8iKYlmes8Cu9Mbp3lKwT9H1L6C7xgBIstkw5UX9Ep6YE+6Osupcr
obbT2arKvHPCSbwJLtaGo1lV2jndFrDtjsC1c8iXcptUI1h01KbLSkuOxsNHSsfP/+8R1VWeWWe02o29
9i5WEol6SOHCWYOK+xp4o0bZ3tgChGNS1EvCD8wIVkmEcr8t4x7PKxSPndajilBQRugu/bsytoeShBFW
4NHZD/bCfjsxUbzHAq6wvZ429/UXX2K7DC6Pxj4qaJm5PaueAj5tmg0piWX06WazKF+oWisrrCPBZPrg
I8/RvHuWa8a29PDsZF9tPrtewPTS9lV0pe27EljTkH8JzX3jCPhaPqSpp0Tqu3NlX778jE44keBLFaDT
1pOiAgxKRoV9/VgzIoOTeKe7Alab9UsKkX9exaoJ5bLarK/Su8sL+K6tkHPkISuU++gIG6o3QJ1QRFag
ZIv9IwGraHeTuj/rYYlvEOY1Ut/5PAttJcqKAJNCcdj5jlkYrV1olmlrEfcl1/yVSBGF+KO7JuVyLOHF
UvHJF0o0HiWwuRnL3mILn2+641KhcNE0aFDVaKFCd4c4lj/J1m6P5jxz96GRrFr9flXpI+WtULsiuYSe
XfvQPPhqkXl8o5VjQo1RW66bLh5vjBDrnV46nOYcSmzLVa+Em1S+QcXRUBCXNdSayPJtxYkfYp5Z1nb3
56pWK207VmM+/ryel/J2LKnvtWk/YlP9Sek7BVK0IsyOBVSnNITlEbgnyQJawes38E86vb4jDDmFzchJ
WoJnotcWJdauzKFXkpzKqGEa3zA7ozs07gTCUjON3rtP+wNXogSuMHh9j4Z0reMgG6wX1vZYRBS1cZdu
4tiLPMGBTaNBku8jG40RaB/U9GJ9VlTe7KEGnDx9OAfonaMRSKiud3mmOxenpeAu4q5HxwwG/he7VbRm
OkqQ6fMXcfIeR2R6+GI+VAwcPdVAOZCZgFblOZOamX1WPgdhRSXxD/to6W8BPHNttGnLZDZTNYYhNIhP
LTEkjvf8KykjlNDONNwMAQWufdCiwPuaDkz2YcKZTMRRWSBzU1vGIOZndHI2DY6ioqmPijoLfNgSmuvM
2NmAkirh1UEL7ueIf2D1k3BQ9R58Xilu6M3n6836gtqfQXh29Rw4EsM8WVC+z6fpMJaLd6+fV8v5nDip
CaHS/OB0PFctRX0biKJP2xLcqUMbB8lUIWkE6W0SwPy4E9OgPlFJ1r2x2kS5qW+Ilu1wRTKjnUnN0Ejs
mRP9hZVf9I62ff0kvHhykw8lMn1L3c89uclnD21ftcI9CVNAuq9iXYfMUAQLCDKntRWsL6DTQjk0SxX2
G67s5GYvnpeSfBGNhjO9S69vZqcbngY4iPqj9Ov712dCKTTQMc4Jxch/kSHN8GmmuSh8P/aD4srvj366
/+KcOEHS9MBVwKiRYGaB4Go1xLq3/vUnou20cUx5+kvCKPn//iqkjN3j0C78Pm/RjPGG+9bZbOyeWjBY
67al/k3lxBycdA9cq6cOmHPYdm7Md7dHi/OmEU/y1IJou/AiXLVyjZaEGLQdlc/IXfLknBy0gTvB3Z5E
pcKOLqr0EcL6AYknlKe8f11ytT671UnBXuK6k3Sv91jfVvp4XgaGcaGfpFl4JF7DXHyctp1JvBfurL4X
Rx+uWZVT7ocW+NT3BeO9d8kx/op1ZtdEdaBGQ1yOpJUDIUo4Tgjib4pCzuQgHNSst2jvqw1LSc65JnJy
uCEP1zBlLKfSe59AuVzwn+rbCs2Tm6JIWOFLYmU7oVazrv7gBt27+Qbv9JS452R0kiTlCEtjw7bITL1v
BEpePngnQOkySBnDW07uMFKYl4VERH4mVC17mq4IE7ynmt71Bled0bp5vuCwYN8j+Eqe9ubPPy88Phsk
QQ8tmaD1g1I+ADWD8VCTpTLlzZJ/EiH2zo5vn1W987QkLHlODbSLKToT6MdWehzVBUjbM0vCkjnPfNce
nFXC6MPH3D6mXXiyCqoXU/XBPRxrbQLQPRTFc9Lyrb+Phwn9CymWR2YauFQ83DB7ouSUkdP+su2OYLUU
HD6tN/T/7I4IrrrjvAGtX7zEFjbrL67C3y/He4l7nxM8ry6X+P4S/51gbgqK1dCh7iQCM0j4X7N+t3eg
ewfCI88J3qPR/kE6Xur4Eneo+Fkz/WCQPftQNnzcsLXRUlbMPEDhZ4PFwzPwt74nJkLt0XZyU1nCM9Z1
UiCnOZGB6ckFlT6EXIRfX7/9rvC7BgbEFLnZsgblCSqM0MvHjy4L42U0OU1Hj96XwltiSB//Mr/V1gEN
6xT/RF2dp8U1SpmCG55MbpZrLSXrLBIIhV/X48soL/Enx/PM7f3uGbP6bwAAAP//rsjNo3UeAAA=
`,
	},

	"/static/css/skeleton.css": {
		local:   "server/static/css/skeleton.css",
		size:    11458,
		modtime: 1508096488,
		compressed: `
H4sIAAAAAAAC/8wa7Y7jNu6/n4KYYoE2sJ3v7EwGLa7dnWkP6HbvOnt3Pw79odh0LIxsuZI8SboY4N7h
3vCe5CDZcmxHzqb/khkgMSlSFEmRIq3xyBvB0zMyVDyHf87CSbjwRvCOFwdBt6mC2WS68OE9eUH4kWQk
StEbwW63C7eoZE0XRjzzRvAoEEFxKCVCmccoQKUIH/76CRiNMJcYeiNIlSrW47HmwAvMJS9FhCEX23E9
SI4zqgJLUaSFN4LpbDy7G2tRvNHY87zxCD6RDUPgCUQ8V5gr6f3vP/+9wn8vgB8Fjb0AfiAS4UkdGEov
gE+Hgm8FKdKDF8DPNH/WwB9KpXiufz1ykUmDkUp/v+Mxaiq9av38VJCI5lsvgH8oyqiiBvqOIREV+APG
lMDfSxQaZbVmRLlORcFo7IXamITmKOCzB1BwSRXl+RoEMqLoC957ADsaq3QN08nkjX7MyD6oQXerSbGv
YGJL8zVMgJSKa0hB4pjmWw2a1YM2fB9I+oeBbriIUQQbvr+HVy0GK7Pctz+kkaY3b8I4UWtgmKjz3LTe
H7mAGF9ohBIYEVuzN0gOi8mk2OuV/yUz9vo6o7ldjcF9Y6bu6aWR5XZpRGkvT894fs7lcnhOg/vCnJM3
eg4zoNJS81PWIyv1B1o1a1h0h68TKqQKopSyuE3ahrvYmIXp8TzH9szHRwmOz2cr9iJcNZ+3ViS14xcR
T+fhvPk0xKnAM3M3xLPZm/s2whAnvBRnpm6I55PwVOyEvuBFxHcOsSXdX6awW4fYEl8wv2DNy5VDbNQJ
5QLi1dIhdk7zi9b8dhFO2oJXpjondIv4duYSm51ddEN8N3U5yQ7ZGWN97kSVYY8PVEpFXLP5U76idrwi
lk7qM0q3U6eEJe6Ze85iSMYj+JgkEpXUIUazME/B5hD0d64DIdu8O9q4de3fI4vjTvaHEMO8p28dlmux
aG10fxglB7jPVo6NdGTRigT+IEYOiT5fhOfU0ooU/iBmkPliflYvx0jiDyGGdb6cndVKO9D4w6ghna8m
Z9XSjkT+MGqQ+91ZvbRClT+IGVT621tHAGt53JBanDGuv4lW59XChrXujII99nfuGNLe551A5p9Hyz/v
7yfRzv8CXl5i3VMxWzHRP4uVg77/6ulzmj6otQuD6z2bj0fwy8dPD16qMgZUgkSli73VLFy+Acn12VIB
YcwUfb8+fIAMiSwFZro4A5UKXm5TXqqm2vSIQNgQiTHwHKb6UFodoEN44hpBI8LYAabhUmAG38J0Wexh
/Y0WxgihT4kJz5U+d+O6kkTrdcPjQx85DZeY3evsFJVCYK7YATCTEBFdrUap4BnCptxCRiXNFYpCoKL5
FoQexXMwTJGZ5VSZjVFtahMvNP/VvZ1xV8MWk0kDS0hG2WENN0+m4IUnkkv4m+A3Ptz8pI8IikbkFyyx
A4Aa0gB8+F5QwnyQJJeBREETPUXEGRdr+Go2mxnHMgXyscC8XqdKpz6kMx/SuQ/pwod06UO6Msard4zi
hT4KHQEbrhTP1jATmJ2ofD4xp6Z0Cp/b1l+EEz26b7LZPQBDpVAEsqqn1xCEUz301UtnXR7zcOXksbwf
4qEFmfeZOAWZDwuimSy6TGbhwsnEKcnk1nJZdrlMw1sXl6VTlMnScln1uSxdXFYOLhNbDP/cKkaLlGwY
qi+Xo32TLmtN6gTQN9UinB1xc7cZDW7hto7BLd1KN7gBJZjKu3B4r92TVZ/nercjMbLbaDJ9+P7h/Q9a
eLJO+UvdCLDYyeP3k3cPzdJs6+qKm0sbI6Lv2W+aF6X6tzoU+O2NLDcZVTe/daECJZ4AK/Kb34w2YioL
Rg5roLnZAhvGo2cdluxemN9W3aZWA2peN6CsJpfLpX5UuFcBYXSbryFCnYPuezlsWtF1It6qSjKd/Wfn
7O/AKqLYqZQguUy4yNZQFgWKiEhskDFGXJCq+ZbzvGq8pVSh4YYauBOkMJ0vEj1vBS/zOKhXZDgXRKfZ
qjVm2mGCxLSUa1jY9puGrmGq8z5nNIavNpuN0UsppGZTcGq1cKZXV5mjclBrW/vksrALV9vZhbLWtjg7
X8KjUjbz1U/O+Rw4O58D1cxncJ0dN5/PW+q00NvbWw3lpdI+UEebWsr6KygEzYg4WHFPwC65zw6qF3B2
jF1Jb1BnSY+Pj24X+mo+fzd/nDjWWyMGF9n1hAHkBQs+4ycXjBxYfM+L+tiOUw0gLxF92OUuGDkk+qlD
DluvTh2n1jvmFNujzq45Z7T1ghmhrJ8M8jLboOhDJRIRpX2oDqynsBOWpTgBFUTKHRexhmsuRCDxPYkM
I1WdjoayzarYm9LKlD6fUjSAFxSqLq6qRCNN0NdlzuOjD3Sbc4ExbA7wL9w807recZg5SZKBUP5+qv/O
Rf99IFMS890xvwwH+fEIfsWMv6AEsnveERFDjAkpmQJp6mYtutQlnNGahIQLoB+frtyExnTBzug4IEWB
RJC8Sq6VRgAgyPgfQzjzOcHBa3cCfZ62/rFadvyjOp+uujBbYGkwvLr054oaVovOMFXr0oWrNOrGDExl
tOtCHHVssVYR9rnaMq1Q5nDdY+bp5lRGNsh8j+EW87h7+GtOfb0ataoLXEc2ePUSiiyWWG3g1gu8456p
q6BJ3wxRitHzhu9Pjqskptx9MG0WAN9BaH4ETZtk8AzbaVq515JzkRHWKnCkuuZ4XlZdI0alCkzkWENE
RcR04JA0Nmrip2NijGhGWGeQDzUzu2/sWxtX9VcyKJmvvzjz9Qz1V83Cvq+uW10T+2PeVnlVBNxVr18Z
bZeZ1t9sx8DYwlwZuF5TRDzGruubqv3oZ8eX+OHMrYdLahJ9TJnqv4FE9TDVfwOJCl69QiB8B42wp1u+
EV8r37YC+pIVAo+NueoOx/VaRqW+p+KubfSx4W2VJ9p16vH2Q52uaz880a9OSmn33b+KT97597dSRcVI
h+j42KERVUA6NlvsFZnrVbRtRNQn7XM72oT508Of380ifeKmL1UI9D3jsr+XXKHvxUyTbksNV9ohfa/Q
8UlHJd9LuMhcDGcNQ6Ph49WjK+76lEFSMlblUtc9njOthTLIyL5P3rpvdBGLQpNXd+k+H68NGUB7hHb5
9gCzs6yiP1AZXXMXX5z0POedIN440LwJj/0jzhFk6J0RpEpr9o7b9erDRB9kSSMr/Mh5nKOU3Utua5Io
0w0QfNf8LoMoqatsc7FxDTc39+3MY7ar6ZNp7trjVHr0lM61v2t+m+j9whWuTU26QalgRw6gOEglykiV
As17xFKaO57Vm4Hfq1UBlXpgJJCoalSN8HIk1Z1TgQxfSK5M3g7NTTjck6xg6ANN4MBL2JFcYWwYpSTf
VozqYlJXj5u6n60Ly4wwZq/S+VAQWc+b8Q1l1fSH6ohQFkBzg6vpQWKkKM+B5HHFHqjyVIoCw+ZWZvuF
SM3z/JXA4fcoXxMmedU5hV2KOWwFjWGDEc908Rwp+oLffOFtyyl3de4lzdtBshjls+LFAN10Mria9zXh
T++HaGcN7f8DAAD//7viGWrCLAAA
`,
	},

	"/static/js/list.min.js": {
		local:   "server/static/js/list.min.js",
		size:    15785,
		modtime: 1508096488,
		compressed: `
H4sIAAAAAAAC/6x7e5PbNpL4V5H4c2mBCOJIiZPsksGosnnUL1eJfXX23j8UvQUSIMUxRcokNGOfxP3s
V3gSpChnspd/ZohXo9Hd6Bda8+xUpbyoqxkBCUoRhWfbw0CO9vBcZGCeRnmsvhL59UiaWYE9M9XDmH86
sjqbNezDqWjYYqE/QrFmv1gUsGH81FSzAuRovoaiPzN9me4TUB9wxZ5mPzVN3QDvB1JVNZ9lRUVnh5qe
Sjb7i7fMl95fPBjyfVM/zR78tKYMe7+9/vEfv/70z1ev3/7z59f/ePWjhx46Ae89FrjjM/t4rBveBueu
C8UZonXsp6QswXtfDyFzGkDUAVMsJ27iiMShRpWBdJsGBHboPepXEqRo1+lZYksz2GV1AwS47Dn0Qjle
h/l31C9ZlfN9mC+XkAEqiG5R6MB5E0Q9tmJzeLacBJKL3qlls5Y3Rco9SViGU5/W6enAKo4yTIDn37VN
enfiRdne5Yyvkk+rtCRt60GUj8fZR84q6kG0H48UFWUfV3XmQVRcrXpkFRfwHsYjvF4J5Krcg+j9eLAi
/NSQctXWDfcgKsfjEksm4B6mzkE4b4rkxJkHUTWxMWka8smDqMaWZIJ9R8X1D6jBfF+0qO2XFpwdPAga
iHjfSShdkfZTlcqR8AM+t5w0PLBA4bnxy6LlPwh0sSc+PdT4LSNNutedqiG768bMlOdGjX8kOcMb9hI1
foE34i9nhxZHMWr8x6ItkpL90vccCE/3RZU7XQo6o3guVmdFyVljWhqNujwdqhZT1Ph7UtGSNS0+n46U
cEaDKO4EGuUpL6oWn0XjkZQn9oocmN5CUhWfc8b//kmiH2RICUuQIykbr7Ngj5QkBAXi9RvJ9+ABaTa/
qRsevEeaqUGJcsa/NywMDojX3wuGBVVntvPVBqBBKUSaxnXFSVGxBntaruwVS7bMzxn/qWRC9P/+6RcK
Ehgk44WLBVA9OAOjIeTwUSgqyZqmZb0syKaSkMbn7HAsCWdNP267zBxF/X6ClgM9qjjVj6q2XVs3jhiq
SyJlc1+0lolAt6XIALFMMdX0a6YCCDtk1riia7QWmRXVrJcN2EQkXiwaXyoe0YAdknsM5V4SRNMRouMc
YypWEUrBEXZI7z65IV6H5DsrdUYRkuVS3c8E2zGpl6PEr8iBxThBiV9UBQcNqmHXdeqcDftFCCEeYPdn
3qPBSfWmvP6PN69f4cnTRTFK8BqlWKNhDpjeJ2GyXELiH0/tHujRKInVlROcMhaA6G0Ipdg1A9JCr+cY
Ew1UdiTGzD7WBZ1xOTFU9i2KEcPzTUiidYwliwDBgqdhb7TWwhhYc3SfhZnhxB5Xp7IM2egk90pxbefr
YL5Be2nPW0CiLEYUMWjUmDrmHqLUfBnr6YhqatjY7uun0Vn1bCXlmGixFiozcaW9sYJwqB8ZHptNc1CK
14jhNcrGfMnuWciWS2gYwnqGRCTGOJGKw15wvQ/opyslpWC2x7JIGWBoA1G2WiG2WiG6XFrOOnhTjXfO
+OjgBmXJP4X3CGd2T0Nq2GRPFNE4zK6Q1+TPeufFkLz4Hza4NgZFdys9Ny0ZaSYn94SRcwAcmDG9vK6m
edvrnYjECs+k52idZaNliiqDVYjiPUiFyGuY9H61EafWrKCCFQYib4o8Z85BSE/tZAjXkDpZrUI4GImS
WPgD5ghW/FrG8Vnpjmm9pwmDkv6+SehEKAFH6TiglWL6d8DVp2oIS+Op5M9l5U1oz1SeVxIQ9gK8DpP7
NEyF2ovS2K4GUBiLASy96XJzL1ARw+7mevQ7rXqAhCZ0hpS3wUwpRWIcjtF1hmAwwmcLbk9Gcu6+oAyY
harR32otWMDTnpUnZe6DLz1GALtwIjSgLCsqtlio/z45UPMNri9a3UGUmJAD1yj1fxWuTN2Bp6Ki9RPs
0PnKbw2+REMHI/gKuR5v8BIN/JvgazR0V4JvkOuFBN+iK38n+Cua9N2Dv6GpUCHYrNFU4BFsNugzjn6w
+RLdjmeCzVdoOmYJNi/R7dAj2HyNpoOHYPMNuhHPBJtvuxh9eR2g9ewZB5oJdmM3xIzetkpqjb5ew5Bh
drlIk838tK5SwgGRHlUGhRXV1ne9bRl/WxxYfeKuoCQadoc2MADEMTSAQdgZWU26Dp27GH313AMYn8Sq
QK2q3gjRxtPd8hhXQz/Uh2PJOMM3R+S6PmiT7g3pL5ezgwcRkUETUZpXAwIQSS9ojTFOIBloVVa27Ox2
rR1FRbT6U+Y2vWFoU2FiE5DBbebCCdzWpussySwPrg5hTizP4eqvTvPn5R/kzyDUpQphJgPdUOr9fyq/
QAR5sm0MhG45dFJHHcMrMmApm0K6ZcbRSBCFQd+Cis7MZ+UBpxoYcYxEzjhgwl7bNRnsOoWkxtHde7iz
9XWZOZDlIRWBTALtQERjnAh+pXOM5+vFwkWilUiw3vWedEPhebBGmBtmZgoLcGumtA52pjErE+5TL40C
PROFLBZMsUd+6AmXizt5PpptJ81/B+RohgNHY6tlcQJZyVIBiJUHERWxir+qKZPRSNFyFQ90KNMSYwT5
62cJsnXuZNyr8zEJRPSGr0b8dF+UVCDQIsdRTsY3txediMY+JZxYl1j0WBuedmgQPNB+NxU2kHHAkLhx
jgiCUkARiVgspGnguabqcBSTkcIHVAQP5PdUeyZhKMWe9Eol6ZWKtN+9TnHUfa9qB3PwrYGhCjbeIQWJ
DvVTnDg5olCE5JR9/F74G1uFZ8AUup1ySbSn0cXomz9kM5E0ZyjDZ6nghbsTDO6b0v7X8QfDiufCe+av
j2K+k4gg8PxlH0AvFiTaxEXVclKlwimTqahtikV3MJg44cGJSVum5n7lzgUKABJjX8ZQYqIzce4ZVCjv
hluLRa9kJRjbJMOE3jbzdd4MaAjR2skkBKPpCoU3skvn59yrJ+6TyryZ9B1IoM/rX+sn1vxAWiltOPEb
dixJysBdtIp28bkD8Ivl1ke73bsXl/8X3+XI2+1eLDxxbZPOJvau3aEo7k2vUNsEJuoapdD1U3J8Lkds
7zXAGqUj4tkUSy67LWESk8MaYEL6GMkFSnvjTzW4IgO5IS2xNEapAOzmXoAFuYYdUvMCx/NjVpWm/p60
r5+q/2zqI2v4J8DgYgEmuJAKdTJihOepbFuiWQwovF9toNG/8rYMb4rykPRsoW+cfFfXof1ADVvTZJVL
q8VGuV2Zb+8jEK2RXAmlLTv1zQOkyeWbRKv7tUTKg2CM6TZXAIH0WnvM1ohtlYIMcql7ABSoT7lURtRv
uVThtQ/rnAlPd4992OEm+OaIXqcT2TLq8ZOiEtKh+vpUOiCjPDRxHw8g8t6zT6ejh66tZOJz0uSMXy6J
3zapzn0jiiVNUyWkA/Me0stlD/QI7OCfhWJRHU/cQ9d3nFgUiYNiKBFMDIJ74HkCmb12Fr59rokgMkv+
s+7Bw+blMvZeTW7Ip6xNsSf+ehhTv24oa3Qm0xzeebYASZ9Oo73Zi1F6o5/CLlTHP7OyDZT2RtIyTWmx
VCqcxGdl2ysdnS/R2Oh4GshJURpDk4D0SJt6PRtvz5OHhR3KGX8tjhtMOF093+3LDEiQJ9yllaSRZxSz
3Bbj9HIxVJQPpmMsoNBwZu+tXHRzElFz5NxAtiSyv1RvWNUWvHhkwTAiMM7UZ5AuqtYs9mDoZaRsmVI3
qe+M4fkmGHVov2FIqatE8oBnoyhRsYDGoYxeJ5DMNJLqaae/sEKGFJAcf3ahYYlmRt4zI9/mApycIAKA
IcUzKPMJehwGvzPeCR8uHUU5VunWDdc2Qb82nDtEsVX38gH+1Igw4a1RBO5YrxMuF3VPQroFDiWmSUAH
tEOJP5QU5VHrA2A5KlkJKISBcMssCpv4cknRYD8HPQtC/79cJK3RUFi8U6UydrR3CgczhGoZdAiMjaOa
+EbQgMR5oNHSkUYbajhkPB/RCa6T5NTqOHOA7WoT2GzwELjWtF/Q7qaBrRvem9dJe2qkAU91XtlSBx6+
0S/XyKuEn2eWzPv6tGmTkJCXlkX63lNRV10NfRvDGjPmppv6sVSbqr9emypF+YlIRhUcUPcmJTiVosvZ
4U19alKm3VXhaKdqL9UvZoAEESfqgjpdMpo1ypsMFdaNlJbQUamJjKFZkuM12mPbb5bu73NZsCIFt7+S
6kJ6Szs/ymPkeSoTNJO9hPNmsZCfFTmwLcimmJogO0M+w2eLRTbcygIT8GHwOTAGAsj8oqpY8//f/vYr
FqvCzASINtSwL3E9O/AoDemkoM5u2lCIoZuLuEHtQfrM0tuWE9HYT8u6YgIGEOGDTKIVGbh7x5to197H
dz77yFKQQGNlTK2PnzaMcKZ1KfA4SUpmzfXMPX2CMj8rmpb/IPDtigysNnPhjek6DuB950FjgG7Bp8Vj
Dz0fQM9d6OoF2UIZVWhoYRfitzdk2Heq5MspEHu7ZzNB4VnFGJ3xerYnj2xGuOqsKzYTYGZ1NSuqgs9q
vmfNU9Gy2af69JeyVNN5PSOUzsjM5Ap8D049vibCU0z1eUHSv2MxYdrUSzmdfikX56BRNrpGBV6jB2z7
zdKH+yIslkvIIjsUFXF8w6HxWXlA5oq5C/T9kl3qfslPdb/2kxdDwrKz5A3RSKgSi/12Eoc9spvAwPNg
8HvgHcgC6L6XErE83I8uIDPZ1ytuKOq7V3HoOrtacexBS++rH45SzR0nrzc1rhnNxowuMsCiLHaS0Gcx
PUg6e1nH4BRXxr2C1NO9Tn57NBxeQ3ez4Uk3yDjaB4BMHASkMMwXC5DL420ll6YVuJqBqIi4Fe75Z9W1
5Hf+OX2t4CB6W1crGJPKmkKIjK6Gnaw0dW5nb6xmRTWjkI5zKjlcLDKQI1lcaeoY5OqBibaaWSbjWHnQ
RNUvISI8G6hmW2egAyyHjAWVARkrD5gKf45xQFCfMYJIBBeTxSqJjHNHeXVtXYSsSCujFkntqug2/WqR
DJQY0ovJ8cgqOrF4+JAh/EdDjUQl/P8PiF2VjUgxlmv2pP3BWk2guBlemVOTGcebEE5sprt6qwM7RAHs
ws8+lQn7QgGB2pH727UjZ0ukqZaQOZEPJ1VN2dtPRwavDNX3sx9f/zZjysLNGpaxhlUpmxWtKQGmsqS5
aH1WmmImWY1IVPT1a9HyTmsl+QTSl91m+G7XLu9Qjl8nDyzl/rGpeS3CDZsofOaBEXXWDqvL5DEtVtAt
vlLyQwUEibfOcKgSNZmChijFIvYm5nb8K71cdEpXL/JZqQ4qQ63Ef6iLCngzT40OMbsq5ZLIeVEtjz/7
L5b/9PEYi2hXlXgTOMBXLf/N1HYQ6WV85mg6UfJHTiezr+opJ0Wbf/eEv129DA7euEYorMP0O/u8pVJE
nLUcJFEaw8XCObrqCp2DDnfndZ6X7DPldvI9DzjR7bwvtk3mGPe0U6AkBI3CoBsGE32SHjC4BX9rah/t
csugQJfAtoDA7dSQI6VjaRd0vC57Mowb+DueLpO/XDxPFkTZd493u3Z52bXLF3e5iEDka5iQAw4ymyCT
QXe0jmUR2r7IuKxzHCCzJy1226mKYycvb8+QnpRmvjj3fP4vBgaiojSbq0OCzcsuRpv1rZBV1RAJ6v0k
Qmahi1jFmq037vECj3BO0r3s9RAzSxUfRqsnOr3Ao8wBkOHrPeYY061XV17geeaXCn1Zf5jKgH5U6IkY
PBMsL7u5QHu8Dvff9cGrLELbxxGNQbaUSy6X+QZ2KPVP1RRI+myQzICkCqQiv1tNJMi/eW5y26oAlGL5
hOaISiuUjlZ7Jl8lNBDF6zBRBSo63kysh8RUaQSJWIyTiMV9nbGygJtnVjMhJ2HsXhjhCAyDFni5yNph
6bPBPhNBfFvT1SJmoynhc4dMO9q9/xFl8WKRyPCkpipHp+pxU2x7/1u+Z/Sv+PpEzytv6h8GrsPUVruo
YtvtGJbZbkturAAJjNZx8JnhLrCbfjix5tMbVrKU182tvRLs+Z4Qsi0ZLgAJDEZd35el3GH6tssSM+8L
LxQsEt6cLAs32Li14SP035JcIs8gynFmeKcqwJVRBh54d9ntWugtk6UHdrv28gLKXw6JSHgd5jr0FWG/
sl5ZVMS92YTS0qf2h2NREYc0eoix+EIPy6UJGWnXAah5/fKWWotik9kIb4mziNv7mMvkQZJhDWvaX/nl
MpWB5SgAS7UArjZGAL9+7pWy6MpihzvwDkTL3Sregm2wo19A8c8XH6IjYj/FanRHl3ALty8u79Yfox0l
q+z71c/x8sVFDNzlKMcDW7VXLmSOCrXD7mkWL9FW/YfbYXtHl8GOLkEgN5F928u7HT1v0Msu2t3tVvFU
4/Ju97REs93Tcraj4oOeX3bwDj3gO4HkevU3ssri5Yu7Ar0XXXeoxOnlcu7QYcrulW7afLEAnrcko6dw
YZ+XpEMVPgCirHWND1L7eB464soa7gx5u4/r9YuN+OvB3qDv1i/uhCV3Tfxa9Si77qkV6AOu/0RoDZZF
N79UHFSqQAw8QLT5Bl4umznGR1sO8iPhTP8EpYKo7ZfVo2XNYmG6CjhYV2tljPikxwfmRK97L3YXQr1Y
yJU/lzXhkrC9B7RHwqO1TekFXS5rGZ238jq19w00l0H0NvetuSUb+1vJE16jR3tM9IQ/mM+P+DfC9/6B
fASP6AmGH+9P4Wm5VDcVc3CMTjF6hIhhDj6I7yeIivYVeQUonGOsPpkNCMzQdhModEzxtfU4hWzRJfY8
xMRfiNg9HRyA3rP+APpjba75N78XPGqn0MQu0pyL0OV2LGdimm7aORCR0MSzk0kmRzJXZDS76RRtlUTC
WLtsZki15ODVT+vseiLHqRNpEbmgOh0S6bGZBeaHSYN1U6VTiwWZOXVX5i3KWdgHQlGMRmpYhD/gioLD
BJCmI0rh5aKrjETY1tf19zVyCuo2CaLYMPbbP1of7ZRqbT0vIIhgwwXTJn1hj04+iD8o2sQw/N8AAAD/
/zgbhRSpPQAA
`,
	},

	"/static/js/table.js": {
		local:   "server/static/js/table.js",
		size:    1432,
		modtime: 1508096488,
		compressed: `
H4sIAAAAAAAC/3xUXW8aOxB951dMnIc1CjHk5ublcjdXVxEqrUgjBaRWiiJk1gO4GHtje/lQxX+v7AV2
E2hfEGufM3PmeGamhc68NBosvg2k86jR0ib8bACsuAWLmYMUvgyfvrKcW4fUz6VjFl1utMMRbnyzu8d6
PlEIKQiTFUvUnr0VaLdDVJh5Y2lymaH11xGVVKSJEVtIS/IHBrlU0nkSseu5VAg0wpk1a8cU6pmfwz10
SrlQxmICFXp8NmvaicxdA0A6V6AI9bFMIbc03oTi2NTYHs/m9GjEki9wFNRQVC2QLeDWHjJES8w66I25
pHZofch1fRNDQrjeHz+gUrTTZFJrtP3R4wBSQMUWuB1LcRZ8cwLOLHKPYsz9WcJfJwTc5NKiO4u+PUHn
VupM5lydJ/x9QrC4Mgvcq2+34bMWuIEFbqUArgVUAdkxYIZKuZfOK8sUdy48AqTwQiKJvHY/4G4/4qqQ
dXBN5V0znsop0ItK4uHJ6rHvXt/Vk/wrdV54cH6rMCVLbmdS/9PpEvDbHFOSzTFbTMyGwIqrAlOSXFUP
CFeQENB8GYBo/VgKAlLUPtr3Sal3V+tOnueoxcNcKkGtWZcdGn9rPWox+hq6dNdoHDtTGS4e0HpHuVK1
GYUUNK7h++Og733+jG8FOk+PI4Za5Ebq4GbS5mIpdTtodOyHMzpKDNYdQ0JFuEoh+Y8rlXpbYHIYJstM
jpomn3qjpHUElxPFuBC9FWp/3CVJUJ206vtlD3WoBW2GCoPKYf/p2/j/QXiXKVcOu7XCvZnNFPZia4va
dpoU3hv9+5VDLkvmday3XCS1PBeH/+G8Mvdw2jxYU1H22g5Glfnf9RQZzs0a9lJJtAxQOfwDoy8Fvmc0
do1fAQAA//8XtlT2mAUAAA==
`,
	},

	"/": {
		isDir: true,
		local: "server",
	},

	"/static": {
		isDir: true,
		local: "server/static",
	},

	"/static/css": {
		isDir: true,
		local: "server/static/css",
	},

	"/static/js": {
		isDir: true,
		local: "server/static/js",
	},
}
