//
// geiger.go
// Copyright (C) 2017 kevin <kevin@ie.suberic.net>
//
// Distributed under terms of the GPL license.
//

package geiger

// New creates a new Counter instance
func New(c Config) (Counter, error) {
	switch c.Model {
	case "gqgmc":
		return NewGQGMC(c)
	}
	return nil, nil
}

// Counter is an interface for Geiger Counters
type Counter interface {
	GetReading() (*Reading, error)
}

// Config contain the configuration for a Geiger Counter
type Config struct {
	Model   string
	Device  string
	Options map[string]string
}

// Reading contains a single geiger reading
type Reading struct {
	CPM float64
}
