//
// pages.go
// Copyright (C) 2017 kevin <kevin@ie.suberic.net>
//
// Distributed under terms of the MIT license.
//

package pages

import (
	"html/template"
	"log"
	"net/http"
	"path"

	"gitlab.com/lyda/gqgmc/devices/geiger"
)

// Pages where data for pages goes
type Pages struct {
	gc geiger.Counter
	staticDir,
	templateDir string
}

type indexPage struct {
	Model   string
	Version string
	Serial  string
	Volts   int16
	CPM     uint16
}

// New create new Pages.
func New(gc geiger.Counter, staticDir, templateDir string) Pages {
	return Pages{gc: gc, staticDir: staticDir, templateDir: templateDir}
}

// Register pages.
func (p Pages) Register() {
	http.HandleFunc("/", p.indexHandler)
	http.HandleFunc("/favicon.ico", p.staticHandler)
	http.HandleFunc("/robots.txt", p.staticHandler)
	http.HandleFunc("/humans.txt", p.staticHandler)
	http.Handle("/static", http.StripPrefix("/static/", http.FileServer(http.Dir(p.staticDir))))
}

func (p Pages) indexHandler(w http.ResponseWriter, r *http.Request) {
	var indexPg indexPage

	indexPg.CPM, _ = p.gc.GetCPM()
	indexPg.Volts, _ = p.gc.Volts()
	indexPg.Model = p.gc.Model()
	indexPg.Version = p.gc.Version()
	indexPg.Serial = p.gc.Serial()

	t, err := template.ParseFiles(path.Join(p.templateDir, "index.html"))
	if err != nil {
		log.Printf("Template error: %s\n", err)
	}
	t.Execute(w, &indexPg)
}

func (p Pages) staticHandler(w http.ResponseWriter, r *http.Request) {
	staticFile := path.Join(p.staticDir, path.Base(r.URL.Path))
	http.ServeFile(w, r, staticFile)
}
