//
// main.go
// Copyright (C) 2017 kevin <kevin@phrye.com>
//
// Distributed under terms of the GPL license.
//

package main

import (
	"fmt"
	"gitlab.com/lyda/gqgmc/devices/geiger"
)

func main() {
	var (
		gc  geiger.Counter
		cpm uint16
		err error
	)

	gc, err = geiger.New(geiger.Config{
		Model:  "gqgmc",
		Device: "/dev/gqgmc",
	})
	if err != nil {
		fmt.Printf("Failed to connect to geiger counter: '%s'\n", err)
		return
	}
	cpm, err = gc.GetCPM()
	if err != nil {
		fmt.Printf("Failed to connect to geiger counter: '%s'\n", err)
		return
	}
	fmt.Printf("CPM: %d\n", cpm)
}
