//
// geiger.go
// Copyright (C) 2017 kevin <kevin@ie.suberic.net>
//
// Distributed under terms of the GPL license.
//

package geiger

// New creates a new Counter instance
func New(c Config) (Counter, error) {
	switch c.Model {
	case "gqgmc":
		return NewGQGMC(c)
	}
	return nil, nil
}

// Counter is an interface for Geiger Counters
type Counter interface {
	Clear() error
	Version() (string, error)
	SerialNum() (string, error)
	GetCPM() (uint16, error)
	GetCPS() (uint16, error)
	Volts() (int16, error)
	GetHistoryData()
	TurnOnCPS() error
	TurnOffCPS() error
	GetAutoCPS() (uint16, error)
	TurnOffPower()
	GetConfiguration()
	SetConfiguration()
	ResetConfiguration()
	SetDate(date string)
	SetTime(time string)
}

// Config contain the configuration for a Geiger Counter
type Config struct {
	Model   string
	Device  string
	Options map[string]string
}

// Reading contains a single geiger reading
type Reading struct {
	CPM float64
}
