# i3going-on

This implements the [i3bar] protocol.

## Testing

To enable this I add the following to `~/.config/i3/config`:


```
bar {
  id bottom
  status_command /path/to/repo/bin/i3going-on
  position bottom
  tray_output primary
  mode hidden
}
```

To show/hide: `i3-msg 'bar mode toggle bottom'`

To restart: `i3-msg restart`

[i3bar]: https://i3wm.org/docs/i3bar-protocol.html

## Goals

  * Modules
    * Disks
      * Show disk usage for all partitions for a given fstype.
      * Send alerts for low disk space.
    * Battery
      * Run this when the battery is low:
        `notify-send -a battery -i /usr/share/icons/Humanity/status/16/battery-caution.svg "Low Battery" "Battery is low.  Please plug in."`
    * Network
      * Show IP address
      * For wifi show ESSID or strength
    * Volume setting for mic and speaker (two different modules)
      * Clicks - left down, right up, middle toggle mute
    * Date
      * Go format for time
      * Click opens calendar
    * Script
      * Emits json output that fits the standard.
  * Conditionals: Only show some modules if a condition is met.
  * Clicks
    * Should be able to set things to run for each modifier:button.  Either (or both) can be set to ALL to match anything.
    * Set environment vars with all the context:
      * `I3GO_NAME="color"`
      * `I3GO_BUTTON=1`
      * `I3GO_MODIFIERS="control:shift"`
      * `I3GO_X=1902`
      * `I3GO_Y=1143`
      * `I3GO_RELATIVE_X=9`
      * `I3GO_RELATIVE_Y=13`
      * `I3GO_WIDTH=24`
      * `I3GO_HEIGHT=22`

