// Package bar handles the main program for i3going-on.
// Copyright (C) 2022 Kevin Lyda <kevin@lyda.ie>
package bar

import (
	"bufio"
	"fmt"
	"os"
	"strings"

	"gitlab.ie.suberic.net/kevin/i3going-on/modules"
	"gopkg.in/yaml.v2"
)

/*
An example click:

  {
		"name":       "thing",
    "button":           1,
    "modifiers":       [],
    "x":             1952,
    "y":             1144,
    "relative_x":      62,
    "relative_y":      14,
    "width":          112,
    "height":          22
  }
*/

func handleCommands(clicks chan modules.Click) {
	logger, _ := os.Create("/tmp/i3going-on.log")

	stdin := bufio.NewReader(os.Stdin)
	for {
		logger.WriteString("Looking for a click...\n")

		object, err := stdin.ReadString('}')
		if err != nil {
			continue
		}
		object = strings.Trim(object, "[,\n")
		logger.WriteString(fmt.Sprintf("Got an object: <<%s>>\n", object))
		objReader := strings.NewReader(object)
		clickParser := yaml.NewDecoder(objReader)
		click := modules.Click{}
		err = clickParser.Decode(&click)
		if err != nil {
			logger.WriteString(fmt.Sprintf("Error on click: %#v\n", err))
			clicks <- modules.Click{
				Name: fmt.Sprintf("ERROR: %s", err),
			}
			continue
		}
		logger.WriteString(fmt.Sprintf("Parsed ok click: %#v\n", click))
		clicks <- click
	}
}
