// Package cmd is the main command line processor.
// Copyright © 2022 Kevin Lyda <kevin@lyda.ie>
package cmd

import (
	"os"
	"path"

	"github.com/spf13/cobra"
	"github.com/spf13/viper"
	"gitlab.ie.suberic.net/kevin/i3going-on/bar"
)

// rootCmd represents the base command when called without any subcommands
var rootCmd = &cobra.Command{
	Use:   "i3going-on",
	Short: "An i3bar status tool",
	Long: `An i3bar status tool

This provides an i3bar compatible status feed with some clickable elements.`,
	Run: bar.Run,
}

// Execute adds all child commands to the root command and sets flags appropriately.
// This is called by main.main(). It only needs to happen once to the rootCmd.
func Execute() {
	err := rootCmd.Execute()
	if err != nil {
		os.Exit(1)
	}
}

func init() {
	cobra.OnInitialize(initConfig)
	home, err := os.UserHomeDir()
	if err != nil {
		home = "/"
	}
	defaultConfig := path.Join(home, ".config", "i3going-on", "config.yaml")
	rootCmd.Flags().StringP("config", "c", defaultConfig, "config file")
}

// initConfig reads in config file and ENV variables if set.
func initConfig() {
	viper.AutomaticEnv() // read in environment variables that match
}
