package config

import (
	"os"

	"gitlab.ie.suberic.net/kevin/i3going-on/modules"
	"gopkg.in/yaml.v3"
)

// Config is the structure for the config file.
type Config struct {
	Refresh int              `yaml:"refresh"`
	Modules []modules.Module `yaml:"modules"`
}

// ReadConfig reads in the config.
func ReadConfig(configFile string) *Config {
	config, err := os.Open(configFile)
	if err != nil {
		return &Config{
			Refresh: 5,
			Modules: []modules.Module{
				modules.NewErrorModule("open", err),
			},
		}
	}

	defer config.Close()
	configParser := yaml.NewDecoder(config)
	cfg := &Config{}
	err = configParser.Decode(&cfg)
	if err != nil {
		return &Config{
			Refresh: 5,
			Modules: []modules.Module{
				modules.NewErrorModule("decode", err),
			},
		}
	} else {
		for _, module := range cfg.Modules {
			module.SetDefaults()
		}
	}

	return cfg
}
