// Package actions handle the actions
// Copyright (C) 2022 Kevin Lyda <kevin@lyda.ie>
package actions

import (
	"strings"

	"github.com/codegoalie/golibnotify"
)

type NotifyAction struct {
	notifier *golibnotify.SimpleNotifier
}

func NewNotifyAction() *NotifyAction {
	return &NotifyAction{
		notifier: golibnotify.NewSimpleNotifier("i3going-on"),
	}
}

// Act shows the notification.
func (a *NotifyAction) Act(args []string) *error {
	var err error
	if len(args) == 0 {
		err = a.notifier.Show("Notification", "Something happened...", "")
	} else if len(args) == 1 {
		err = a.notifier.Show("Notification", args[0], "")
	} else if len(args) == 2 {
		err = a.notifier.Show(args[0], args[1], "")
	} else if len(args) == 3 {
		err = a.notifier.Show(args[0], args[1], args[2])
	} else {
		err = a.notifier.Show(args[0], strings.Join(args[1:len(args)-2], " "), args[len(args)-1])
	}
	if err != nil {
		return &err
	}
	return nil
}
