// Package modules implements all the modules.
// Copyright (C) 2022 Kevin Lyda <kevin@lyda.ie>
package modules

import (
	"fmt"
	"strings"
	"time"
)

// DateMod module parameters for the text module.
type DateMod struct {
	name      string
	onclick   string
	blink     bool
	Format    string `yaml:"format"`
	BlinkChar string `yaml:"blink-char"`
}

// NewDate creates a DateMod instance.
func NewDate(m *Module) *DateMod {
	d := &DateMod{
		name:    m.Name,
		onclick: m.OnClick,
	}
	return d
}

// SetDefaults sets defaults.
func (d *DateMod) SetDefaults() {
	if d.Format == "" {
		d.Format = "06/01/02 15:04"
	}
}

// Name returns the name setting for the module.
func (d *DateMod) Name() string {
	return d.name
}

// OnClick returns the on-click setting for the module.
func (d *DateMod) OnClick() string {
	return d.onclick
}

// Render renders the module.
func (d *DateMod) Render() string {

	now := time.Now().Format(d.Format)
	if d.BlinkChar != "" {
		if d.blink {
			now = strings.ReplaceAll(now, d.BlinkChar, " ")
		}
		d.blink = !d.blink
	}
	return fmt.Sprintf(`{"name": "%s", "full_text": "%s"}`, d.name, now)
}
