// Package modules implements all the modules.
// Copyright (C) 2022 Kevin Lyda <kevin@lyda.ie>
package modules

import (
	"fmt"
)

// ErrorMod module parameters for the text module.
type ErrorMod struct {
	name    string
	onclick string
	Error   string
}

// NewError creates a ErrorMod instance.
func NewError(m *Module) *ErrorMod {
	e := &ErrorMod{
		name:    m.Name,
		onclick: m.OnClick,
	}
	if e.name == "" {
		e.name = "error"
	}
	return e
}

// SetDefaults sets defaults.
func (e *ErrorMod) SetDefaults() {
	return
}

// Name returns the name setting for the module.
func (e *ErrorMod) Name() string {
	return e.name
}

// OnClick returns the on-click setting for the module.
func (e *ErrorMod) OnClick() string {
	return e.onclick
}

// Render renders the module.
func (e *ErrorMod) Render() string {
	// TODO: Make color and name optional.
	return fmt.Sprintf(`{"name": "%s", "full_text": "%s", "color": "#ff1111"}`, e.name, e.Error)
}

// NewErrorModule creates a Module instance.
func NewErrorModule(name string, errtxt error) Module {
	return Module{
		Module:  "error",
		Name:    "decode",
		OnClick: "",
		Params: &ErrorMod{
			name:  "open",
			Error: errtxt.Error(),
		},
	}
}
