// Package modules implements all the modules.
// Copyright (C) 2022 Kevin Lyda <kevin@lyda.ie>
package modules

/*

To implement this, these are some good modules to look at:

https://pkg.go.dev/github.com/mdlayher/wifi
https://pkg.go.dev/net#Interface

*/

import (
	"fmt"
)

// InterfacesMod module parameters for the text module.
type InterfacesMod struct {
	name    string
	onclick string
	Format  string `yaml:"format"`
}

// NewInterfaces creates a InterfacesMod instance.
func NewInterfaces(m *Module) *InterfacesMod {
	t := &InterfacesMod{
		name:    m.Name,
		onclick: m.OnClick,
	}
	return t
}

// SetDefaults sets defaults.
func (t *InterfacesMod) SetDefaults() {
	if t.Format == "" {
		t.Format = "Hello world!"
	}
}

// Name returns the name setting for the module.
func (t *InterfacesMod) Name() string {
	return t.name
}

// OnClick returns the on-click setting for the module.
func (t *InterfacesMod) OnClick() string {
	return t.onclick
}

// Render renders the module.
func (t *InterfacesMod) Render() string {
	// TODO: Make color and name optional.
	return fmt.Sprintf(`{"name": "%s", "full_text": "Not Implemented Yet", "color": "#ff0000"}`, t.name)
}
