// Package modules implements all the modules.
// Copyright (C) 2022 Kevin Lyda <kevin@lyda.ie>
package modules

import (
	"fmt"
)

// TextMod module parameters for the text module.
type TextMod struct {
	name    string
	onclick string
	Text    string `yaml:"text"`
	Color   string `yaml:"color"`
}

// NewText creates a TextMod instance.
func NewText(m *Module) *TextMod {
	t := &TextMod{
		name:    m.Name,
		onclick: m.OnClick,
	}
	return t
}

// SetDefaults sets defaults.
func (t *TextMod) SetDefaults() {
	if t.Text == "" {
		t.Text = "Hello world!"
	}
}

// Name returns the name setting for the module.
func (t *TextMod) Name() string {
	return t.name
}

// OnClick returns the on-click setting for the module.
func (t *TextMod) OnClick() string {
	return t.onclick
}

// Render renders the module.
func (t *TextMod) Render() string {
	if t.Color != "" {
		return fmt.Sprintf(`{"name": "%s", "full_text": "%s", "color": "%s"}`, t.name, t.Text, t.Color)
	}
	return fmt.Sprintf(`{"name": "%s", "full_text": "%s"}`, t.name, t.Text)
}
