// Package dclish A DCL-like command line parser.
package dclish

import (
	"fmt"
	"strings"
)

// ActionFunc is the function that a command runs.
type ActionFunc func(*Command) error

// Flag is a flag for a command.
type Flag struct {
	Name        string
	Value       string
	Description string
}

// Flags is the list of flags.
type Flags []*Flag

// Command contains the definition of a command, it's flags and subcommands.
type Command struct {
	Command     string
	Flags       Flags
	Args        []string
	Commands    []*Command
	Action      ActionFunc
	Description string
}

// Commands is the full list of commands.
type Commands []*Command

// ParseAndRun parses a command line and runs the command.
func (c Commands) ParseAndRun(line string) error {
	// TODO: this doesn't handle a DCL command line completely.
	words := strings.Fields(line)
	fmt.Printf("TODO ParseAndRun need to parse flags: %s\n", words)
	cmd := strings.ToUpper(words[0])
	for i := range c {
		if c[i].Command == cmd {
			if c[i].Action == nil {
				fmt.Printf("Command not implemented:\n%s\n", c[i].Description)
				return nil
			}
			err := c[i].Action(c[i])
			return err
		}
	}
	fmt.Printf("ERROR: Unknown command '%s'\n", cmd)
	return nil
}
