// Package repl implements the main event loop.
package repl

import (
	"fmt"

	"github.com/chzyer/readline"
)

// Loop is the main event loop.
func Loop(user string) error {
	fmt.Printf("TODO: get config for user %s using xdg.", user)
	rl, err := readline.New("BULLETIN> ")
	if err != nil {
		return err
	}
	defer rl.Close()

	for {
		line, err := rl.Readline()
		if err != nil {
			return err
		}
		if len(line) == 0 {
			continue
		}
		err = commands.ParseAndRun(line)
		if err != nil {
			return err
		}
	}

	return nil
}
