package repl

import (
	"fmt"
	"strconv"
	"strings"
)

// ParseNumberList takes a string with a number list
// like "1,8,3-6,10,20-30" and returns a number list like
// []int64{1,8,3,4,5,6,10,20,21,...,30}.  Well, also an error since
// somethings can go wrong here.
func ParseNumberList(input string) ([]int64, error) {
	var result []int64
	segments := strings.Split(input, ",")

	for _, segment := range segments {
		segment = strings.TrimSpace(segment)
		if strings.Contains(segment, "-") {
			// Handle range
			parts := strings.SplitN(segment, "-", 2)
			if len(parts) != 2 {
				return nil, fmt.Errorf("invalid range format: %s", segment)
			}
			start, err1 := strconv.ParseInt(parts[0], 10, 64)
			end, err2 := strconv.ParseInt(parts[1], 10, 64)
			if err1 != nil || err2 != nil || start > end {
				return nil, fmt.Errorf("invalid range: %s", segment)
			}
			for i := start; i <= end; i++ {
				result = append(result, i)
			}
		} else {
			// Handle single number
			num, err := strconv.ParseInt(segment, 10, 64)
			if err != nil {
				return nil, fmt.Errorf("invalid number: %s", segment)
			}
			result = append(result, num)
		}
	}
	return result, nil
}
