// Package repl implements the main event loop.
package repl

import (
	"errors"
	"fmt"
	"strings"

	"git.lyda.ie/kevin/bulletin/dclish"
	"git.lyda.ie/kevin/bulletin/folders"
	"git.lyda.ie/kevin/bulletin/this"
)

// ActionSetAccess handles the `SET ACCESS` command.
func ActionSetAccess(_ *dclish.Command) error {
	fmt.Println("TODO: implement ActionSetAccess.")
	return nil
}

// ActionSetAlways handles the `SET ALWAYS` command.
func ActionSetAlways(_ *dclish.Command) error {
	fmt.Println("TODO: implement ActionSetAlways.")
	return nil
}

// ActionSetNoalways handles the `SET NOALWAYS` command.
func ActionSetNoalways(_ *dclish.Command) error {
	fmt.Println("TODO: implement ActionSetNoalways.")
	return nil
}

// ActionSetBrief handles the `SET BRIEF` command.
func ActionSetBrief(_ *dclish.Command) error {
	fmt.Println("TODO: implement ActionSetBrief.")
	return nil
}

// ActionSetNobrief handles the `SET NOBRIEF` command.
func ActionSetNobrief(_ *dclish.Command) error {
	fmt.Println("TODO: implement ActionSetNobrief.")
	return nil
}

// ActionSetDefaultExpire handles the `SET DEFAULT_EXPIRE` command.
func ActionSetDefaultExpire(_ *dclish.Command) error {
	fmt.Println("TODO: implement ActionSetDefaultExpire.")
	return nil
}

// ActionSetExpireLimit handles the `SET EXPIRE_LIMIT` command.
func ActionSetExpireLimit(_ *dclish.Command) error {
	fmt.Println("TODO: implement ActionSetExpireLimit.")
	return nil
}

// ActionSetFolder handles the `SET FOLDER` command.  This selects a folder.
func ActionSetFolder(cmd *dclish.Command) error {
	if len(cmd.Args) != 1 {
		return errors.New("TODO: need to add code for /MARK")
	}
	// TODO: Move shared code here and in ActionSelect and ActionDirectory into a function.
	if strings.Contains(cmd.Args[0], "%") {
		return errors.New("Folder name cannot contain a %")
	}
	folder := folders.FindFolder(cmd.Args[0])
	if folder.Name == "" {
		return errors.New("Unable to select the folder")
	}
	if folders.IsFolderAccess(folder.Name, this.User.Login) {
		this.Folder = folder
		fmt.Printf("Folder has been set to '%s'.\n", folder.Name)
		return nil
	}
	// TODO: Should be:
	//       WRITE(6,'('' You are not allowed to access folder.'')')
	//       WRITE(6,'('' See '',A,'' if you wish to access folder.'')')
	return errors.New("Unable to select the folder")
}

// ActionSetNotify handles the `SET NOTIFY` command.
func ActionSetNotify(_ *dclish.Command) error {
	fmt.Println("TODO: implement ActionSetNotify.")
	return nil
}

// ActionSetNonotify handles the `SET NONOTIFY` command.
func ActionSetNonotify(_ *dclish.Command) error {
	fmt.Println("TODO: implement ActionSetNonotify.")
	return nil
}

// ActionSetPrivileges handles the `SET PRIVILEGES` command.
func ActionSetPrivileges(cmd *dclish.Command) error {
	// TODO: OK, need a better parser.
	switch cmd.Args[0] {
	case "CREATE":
		if len(cmd.Args) != 2 {
			fmt.Println("ERROR: Must pass single login.")
			return nil
		}
		fmt.Println("TODO: Create user creation routine - see repl/repl.go.")
	case "DELETE":
		if len(cmd.Args) != 2 {
			fmt.Println("ERROR: Must pass single login.")
			return nil
		}
		fmt.Println("TODO: Create user delete routine - see repl/repl.go.")
	case "SSH":
		fmt.Println("TODO: Create ssh routine.")
	case "ADMIN":
		fmt.Println("TODO: Create an admin bit set/unset routine.")
	case "NOADMIN":
		fmt.Println("TODO: Create an admin bit set/unset routine.")
	case "MOD":
		fmt.Println("TODO: Create a mod bit set/unset routine.")
	case "NOMOD":
		fmt.Println("TODO: Create a mod bit set/unset routine.")
	case "ENABLE":
		fmt.Println("TODO: Create a disable bit set/unset routine.")
	case "DISABLE":
		fmt.Println("TODO: Create a disable bit set/unset routine.")
	default:
		fmt.Println("ERROR: Command not understood.")
	}
	return nil
}

// ActionSetPromptExpire handles the `SET PROMPT_EXPIRE` command.
func ActionSetPromptExpire(_ *dclish.Command) error {
	fmt.Println("TODO: implement ActionSetPromptExpire.")
	return nil
}

// ActionSetNoPromptExpire handles the `SET NOPROMPT_EXPIRE` command.
func ActionSetNoPromptExpire(_ *dclish.Command) error {
	fmt.Println("TODO: implement ActionSetNopromptExpire.")
	return nil
}

// ActionSetReadNew handles the `SET READNEW` command.
func ActionSetReadNew(_ *dclish.Command) error {
	fmt.Println("TODO: implement ActionSetReadNew.")
	return nil
}

// ActionSetNoReadNew handles the `SET READNEW` command.
func ActionSetNoReadNew(_ *dclish.Command) error {
	fmt.Println("TODO: implement ActionSetNoReadNew.")
	return nil
}

// ActionSetShowNew handles the `SET SHOWNEW` command.
func ActionSetShowNew(_ *dclish.Command) error {
	fmt.Println("TODO: implement ActionSetShowNew.")
	return nil
}

// ActionSetNoShowNew handles the `SET SHOWNEW` command.
func ActionSetNoShowNew(_ *dclish.Command) error {
	fmt.Println("TODO: implement ActionSetNoShowNew.")
	return nil
}

// ActionSetSystem handles the `SET SYSTEM` command.
func ActionSetSystem(_ *dclish.Command) error {
	fmt.Println("TODO: implement ActionSetSystem.")
	return nil
}
