// Package repl implements the main event loop.
package repl

import (
	"fmt"

	"github.com/carlmjohnson/versioninfo"

	"git.lyda.ie/kevin/bulletin/dclish"
	"git.lyda.ie/kevin/bulletin/this"
)

// ActionShowFlags handles the `SHOW FLAGS` command.
func ActionShowFlags(_ *dclish.Command) error {
	// ctx := storage.Context()
	flagset := false
	fmt.Printf("For the selected folder %s:\n", this.Folder.Name)
	if this.Folder.Notify != 0 {
		fmt.Println("  NOTIFY is set.")
		flagset = true
	}
	if this.Folder.Readnew != 0 {
		fmt.Println("  READNEW is set.")
		flagset = true
	}
	if this.Folder.Brief != 0 {
		fmt.Println("  BRIEF is set.")
		flagset = true
	}
	if this.Folder.Shownew != 0 {
		fmt.Println("  SHOWNEW is set.")
		flagset = true
	}
	if !flagset {
		fmt.Println("  No flags are set.")
	}
	return nil
}

// ActionShowFolder handles the `SHOW FOLDER` command.
func ActionShowFolder(_ *dclish.Command) error {
	fmt.Println("TODO: implement ActionShowFolder.")
	return nil
}

// ActionShowNew handles the `SHOW NEW` command.
func ActionShowNew(_ *dclish.Command) error {
	fmt.Println("TODO: implement ActionShowNew.")
	return nil
}

// ActionShowPrivileges handles the `SHOW PRIVILEGES` command.
func ActionShowPrivileges(_ *dclish.Command) error {
	fmt.Println("TODO: implement ActionShowPrivileges.")
	return nil
}

// ActionShowUser handles the `SHOW USER` command.
func ActionShowUser(_ *dclish.Command) error {
	fmt.Println("TODO: implement ActionShowUser.")
	return nil
}

// ActionShowVersion handles the `SHOW VERSION` command.
func ActionShowVersion(_ *dclish.Command) error {
	rev := versioninfo.Revision
	if len(rev) > 7 {
		rev = rev[len(rev)-7:]
	}
	fmt.Printf("BULLETIN Version 2.0.7g (%s)\n", rev)
	fmt.Printf("Linked on %s\n",
		versioninfo.LastCommit.Format("2006-05-04 15:02:01"))
	return nil
}
