// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.29.0
// source: folders.sql

package storage

import (
	"context"
	"database/sql"
)

const createFolder = `-- name: CreateFolder :exec
  INSERT INTO folders (
  name, always, brief, description, notify, readnew, shownew, system,
  expire, visibility
) VALUES (
  ?, ?, ?, ?, ?, ?, ?, ?, ?, ?
)
`

type CreateFolderParams struct {
	Name        string
	Always      int64
	Brief       int64
	Description string
	Notify      int64
	Readnew     int64
	Shownew     int64
	System      int64
	Expire      int64
	Visibility  int64
}

func (q *Queries) CreateFolder(ctx context.Context, arg CreateFolderParams) error {
	_, err := q.db.ExecContext(ctx, createFolder,
		arg.Name,
		arg.Always,
		arg.Brief,
		arg.Description,
		arg.Notify,
		arg.Readnew,
		arg.Shownew,
		arg.System,
		arg.Expire,
		arg.Visibility,
	)
	return err
}

const deleteFolder = `-- name: DeleteFolder :exec
DELETE FROM folders WHERE name=?
`

func (q *Queries) DeleteFolder(ctx context.Context, name string) error {
	_, err := q.db.ExecContext(ctx, deleteFolder, name)
	return err
}

const findFolderExact = `-- name: FindFolderExact :one
SELECT name FROM folders where name = ?
`

func (q *Queries) FindFolderExact(ctx context.Context, name string) (string, error) {
	row := q.db.QueryRowContext(ctx, findFolderExact, name)
	err := row.Scan(&name)
	return name, err
}

const findFolderPrefix = `-- name: FindFolderPrefix :one
SELECT name FROM folders where name LIKE ?
ORDER BY name
LIMIT 1
`

func (q *Queries) FindFolderPrefix(ctx context.Context, name string) (string, error) {
	row := q.db.QueryRowContext(ctx, findFolderPrefix, name)
	err := row.Scan(&name)
	return name, err
}

const getFolderExpire = `-- name: GetFolderExpire :one
SELECT expire FROM folders WHERE name = ?
`

func (q *Queries) GetFolderExpire(ctx context.Context, name string) (int64, error) {
	row := q.db.QueryRowContext(ctx, getFolderExpire, name)
	var expire int64
	err := row.Scan(&expire)
	return expire, err
}

const isFolderAccess = `-- name: IsFolderAccess :one
SELECT 1 FROM folders AS f LEFT JOIN owners AS c ON f.name = c.folder
  WHERE f.name = ? AND (f.visibility = 0 OR c.OWNER = ?)
`

type IsFolderAccessParams struct {
	Name  string
	Owner sql.NullString
}

func (q *Queries) IsFolderAccess(ctx context.Context, arg IsFolderAccessParams) (int64, error) {
	row := q.db.QueryRowContext(ctx, isFolderAccess, arg.Name, arg.Owner)
	var column_1 int64
	err := row.Scan(&column_1)
	return column_1, err
}

const isFolderOwner = `-- name: IsFolderOwner :one
SELECT 1 FROM folders AS f LEFT JOIN owners AS c ON f.name = c.folder
  WHERE f.name = ? AND c.OWNER = ?
`

type IsFolderOwnerParams struct {
	Name  string
	Owner sql.NullString
}

func (q *Queries) IsFolderOwner(ctx context.Context, arg IsFolderOwnerParams) (int64, error) {
	row := q.db.QueryRowContext(ctx, isFolderOwner, arg.Name, arg.Owner)
	var column_1 int64
	err := row.Scan(&column_1)
	return column_1, err
}

const listFolder = `-- name: ListFolder :many
SELECT f.name, count(m.id) as count, f.description
FROM folders AS f LEFT JOIN messages AS m ON f.name = m.folder
GROUP By f.name
ORDER BY f.name
`

type ListFolderRow struct {
	Name        string
	Count       int64
	Description string
}

func (q *Queries) ListFolder(ctx context.Context) ([]ListFolderRow, error) {
	rows, err := q.db.QueryContext(ctx, listFolder)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []ListFolderRow
	for rows.Next() {
		var i ListFolderRow
		if err := rows.Scan(&i.Name, &i.Count, &i.Description); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listFolderForAdmin = `-- name: ListFolderForAdmin :many
SELECT f.name, count(m.id) as count, f.description
FROM folders AS f LEFT JOIN messages AS m ON f.name = m.folder
GROUP By f.name
ORDER BY f.name
`

type ListFolderForAdminRow struct {
	Name        string
	Count       int64
	Description string
}

func (q *Queries) ListFolderForAdmin(ctx context.Context) ([]ListFolderForAdminRow, error) {
	rows, err := q.db.QueryContext(ctx, listFolderForAdmin)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []ListFolderForAdminRow
	for rows.Next() {
		var i ListFolderForAdminRow
		if err := rows.Scan(&i.Name, &i.Count, &i.Description); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}
