-- name: CreateMessage :exec
INSERT INTO messages (
  id, folder, author, subject, message, permanent, shutdown, expiration
) VALUES (
  (SELECT COALESCE(MAX(id), 0) + 1 FROM messages AS m WHERE m.folder = ?),
  ?, ?, ?, ?, ?, ?, ?);

-- name: SetMessageSeen :exec
INSERT INTO seen (login, folder, msgid) VALUES (?, ?, ?);

-- name: MarkMessage :exec
INSERT INTO mark (login, folder, msgid) VALUES (?, ?, ?);

-- name: ListMessages :many
SELECT id, folder, author, subject, message, expiration, create_at, update_at
FROM messages
WHERE folder = ?;
