// Package repl implements the main event loop.
package repl

import (
	"fmt"
	"strings"

	"git.lyda.ie/kevin/bulletin/accounts"
	"git.lyda.ie/kevin/bulletin/dclish"
	"git.lyda.ie/kevin/bulletin/editor"
)

// ActionDirectory handles the `DIRECTORY` command.  This lists all the
// messages in the current folder.
func ActionDirectory(cmd *dclish.Command) error {
	// TODO: flag parsing.
	if len(cmd.Args) == 1 {
		folder := strings.ToUpper(cmd.Args[0])
		// TODO: Check folder is valid.
		accounts.User.CurrentFolder = folder
	}
	fmt.Println("TODO: List messages in folder")
	return nil
}

// ActionAdd handles the `ADD` command.  This adds a message to a folder.
func ActionAdd(cmd *dclish.Command) error {
	optAll := 0
	optBell := 0
	optBroadcast := 0
	optEdit := 0
	optExpiration := 0
	optExtract := 0
	optFolder := []string{}
	optIndent := 0
	optPermanent := 0
	optShutdown := 0
	optSignature := 0
	optSubject := ""
	optSystem := 0

	if cmd.Flags["/ALL"].Value == "true" {
		optAll = 1
	}
	if cmd.Flags["/BELL"].Value == "true" {
		optBell = 1
	}
	if cmd.Flags["/BROADCAST"].Value == "true" {
		optBroadcast = 1
	}
	if cmd.Flags["/EDIT"].Value == "true" {
		optEdit = 1
	}
	if cmd.Flags["/EXPIRATION"].Value == "true" {
		optExpiration = 1
	}
	if cmd.Flags["/EXTRACT"].Value == "true" {
		optExtract = 1
	}
	if cmd.Flags["/FOLDER"].Value != "" {
		fmt.Printf("/FOLDER = %s\n", cmd.Flags["/FOLDER"].Value)
		optFolder = strings.Split(cmd.Flags["/FOLDER"].Value, ",")
	}
	if cmd.Flags["/INDENT"].Value == "true" {
		optIndent = 1
	}
	if cmd.Flags["/PERMANENT"].Value == "true" {
		optPermanent = 1
	}
	if cmd.Flags["/SHUTDOWN"].Value == "true" {
		optShutdown = 1
	}
	if cmd.Flags["/SIGNATURE"].Value == "true" {
		optSignature = 1
	}
	if cmd.Flags["/SUBJECT"].Value != "" {
		optSubject = cmd.Flags["/SUBJECT"].Value
	}
	if cmd.Flags["/SYSTEM"].Value == "true" {
		optSystem = 1
	}

	todoRemove := optAll + optBell + optBroadcast + optEdit + optExpiration + optExtract + optIndent + optPermanent + optShutdown + optSignature + optSystem
	if len(optFolder) == 0 {
		optFolder = []string{accounts.User.CurrentFolder}
	}
	// TODO: check if folders exist.
	// TODO: prompt for subject if optSubject == ""

	message, err := editor.Editor(fmt.Sprintf("Enter message for '%s'...", optSubject), "Edit message")
	if err != nil {
		return err
	}
	fmt.Printf("TODO: The message you entered %d...\n%s\n...will be posted to %s.\n", todoRemove, message, strings.Join(optFolder, ", "))
	return nil
}
