// Package repl implements the main event loop.
package repl

import (
	"fmt"
	"path"

	"git.lyda.ie/kevin/bulletin/accounts"
	"github.com/adrg/xdg"
	"github.com/chzyer/readline"
)

// Loop is the main event loop.
func Loop() error {
	// fmt.Printf("TODO: get config for user %s using xdg.\n", user)
	rl, err := readline.NewEx(
		&readline.Config{
			Prompt: "BULLETIN> ",
			HistoryFile: path.Join(xdg.ConfigHome, "BULLETIN",
				fmt.Sprintf("%s.history", accounts.User.Login)),
			// TODO: AutoComplete:    completer,
			InterruptPrompt:   "^C",
			EOFPrompt:         "EXIT",
			HistorySearchFold: true,
		})
	if err != nil {
		return err
	}
	defer rl.Close()

	// TODO: Remove once commands are implemented.
	unimplemented := 0
	total := 0
	for c := range commands {
		if commands[c].Action == nil {
			unimplemented++
		}
		total++
	}
	fmt.Printf("TODO: %d out of %d commands still to be implemented.\n",
		unimplemented, total)
	// TODO: END

	for {
		line, err := rl.Readline()
		if err != nil {
			if err.Error() == "Interrupt" {
				commands.ParseAndRun("QUIT")
			} else if err.Error() == "EOF" {
				commands.ParseAndRun("EXIT")
			}
			return err
		}
		if len(line) == 0 {
			continue
		}
		err = commands.ParseAndRun(line)
		if err != nil {
			fmt.Printf("ERROR: %s.\n", err)
		}
	}
}
