package storage

import (
	"fmt"
	"strings"
	"time"
)

// String renders a message.
func (m *Message) String() string {
	buf := &strings.Builder{}
	changed := "*"
	if m.CreateAt.Compare(m.UpdateAt) == 0 {
		changed = ""
	}
	fmt.Fprintf(buf, "From: \"%s\" %s%s\n", m.Author,
		m.CreateAt.Format("02-JAN-2006 15:04:05"), changed)
	fmt.Fprintf(buf, "To: %s\n", m.Folder)
	fmt.Fprintf(buf, "Subj: %s\n\n", m.Subject)
	fmt.Fprintf(buf, "%s\n", m.Message)

	return buf.String()
}

// OneLine renders a message in a line.
func (m *Message) OneLine(expire bool) string {
	var t time.Time
	if expire {
		t = m.Expiration
	} else {
		t = m.CreateAt
	}
	ts := t.Format("2006-01-02 15:04:05")
	return fmt.Sprintf("%4d %-43.43s %-12.12s %-10s\n", m.ID, m.Subject, m.Author, ts)
}

// String displays a user (mainly used for debugging).
func (u User) String() string {
	return fmt.Sprintf("User %s (%s) [a%d, m%d, !%d, d%d] [%s]",
		u.Login,
		u.Name,
		u.Admin,
		u.Moderator,
		u.Alert,
		u.Disabled,
		u.LastLogin.Format("06-05-04 15:02:01"))
}

// String displays a folder (mainly used for debugging).
func (f Folder) String() string {
	return fmt.Sprintf("Folder %s (%s) [a%d, b%d, n%d, rn%d, sn%d, sys%d, exp%d, v%d]",
		f.Name,
		f.Description,
		f.Always,
		f.Brief,
		f.Notify,
		f.Readnew,
		f.Shownew,
		f.System,
		f.Expire,
		f.Visibility)
}
