-- name: CreateFolder :exec
INSERT INTO folders (
  name, always, brief, description, notify, readnew, shownew, system,
  expire, visibility
) VALUES (
  ?, ?, ?, ?, ?, ?, ?, ?, ?, ?
);

-- name: AddFolderOwner :exec
INSERT INTO owners (folder, login) VALUES (?, ?);

-- name: ListFolderForAdmin :many
SELECT f.name, count(m.id) as count, f.description
FROM folders AS f LEFT JOIN messages AS m ON f.name = m.folder
GROUP By f.name
ORDER BY f.name;

-- name: ListFolder :many
SELECT f.name, count(m.id) as count, f.description
FROM folders AS f LEFT JOIN messages AS m ON f.name = m.folder
GROUP By f.name
ORDER BY f.name;

-- name: FindFolderExact :one
SELECT * FROM folders where name = ?;

-- name: FindFolderPrefix :one
SELECT * FROM folders where name LIKE ?
ORDER BY name
LIMIT 1;

-- name: IsFolderAccess :one
SELECT 1 FROM folders AS f LEFT JOIN owners AS o ON f.name = c.folder
  WHERE f.name = ? AND (f.visibility = 0 OR o.login = ?);

-- name: IsFolderOwner :one
SELECT 1 FROM owners WHERE folder = ? AND login = ?;

-- name: GetFolderExpire :one
SELECT expire FROM folders WHERE name = ?;

-- name: UpdateFolderAlways :exec
UPDATE folders SET always = ? WHERE name = ?;

-- name: UpdateFolderSystem :exec
UPDATE folders SET system = ? WHERE name = ?;

-- name: UpdateFolderBrief :exec
UPDATE folders SET brief = ? WHERE name = ?;

-- name: UpdateFolderNotify :exec
UPDATE folders SET notify = ? WHERE name = ?;

-- name: UpdateFolderReadnew :exec
UPDATE folders SET readnew = ? WHERE name = ?;

-- name: UpdateFolderShownew :exec
UPDATE folders SET shownew = ? WHERE name = ?;

-- name: UpdateFolderVisibility :exec
UPDATE folders SET visibility = ? WHERE name = ?;

-- name: UpdateFolderExpire :exec
UPDATE folders SET expire = ? WHERE name = ?;
