-- name: CreateMessage :exec
INSERT INTO messages (
  id, folder, author, subject, message, permanent, shutdown, expiration
) VALUES (
  (SELECT COALESCE(MAX(id), 0) + 1 FROM messages AS m WHERE m.folder = ?1),
  ?2, ?1, ?3, ?4, ?5, ?6, ?7);

-- name: SetMessageSeen :exec
INSERT INTO seen (login, folder, msgid) VALUES (?, ?, ?);

-- name: UnsetMessageSeen :exec
DELETE FROM seen WHERE login = ? AND folder = ? AND msgid = ?;

-- name: ReadMessage :one
SELECT * FROM messages WHERE folder = ? AND id = ?;

-- name: NextMsgid :one
SELECT CAST(COALESCE(MIN(id), 0) AS INT) FROM messages AS m
  WHERE m.folder = ?1 AND m.id > ?2
  AND id NOT IN (SELECT id FROM seen AS s WHERE s.folder = ?1 AND s.login = ?3);

-- name: NextMsgidIgnoringSeen :one
SELECT CAST(MIN(id) AS INT) FROM messages AS m
  WHERE m.folder = ?1 AND m.id > ?2;

-- name: PrevMsgid :one
SELECT CAST(COALESCE(MAX(id), 0) AS INT) FROM messages AS m
  WHERE m.folder = ?1 AND m.id < ?2
  AND id NOT IN (SELECT id FROM seen AS s WHERE s.folder = ?1 AND s.login = ?3);

-- name: PrevMsgidIgnoringSeen :one
SELECT CAST(MAX(id) AS INT) FROM messages AS m
  WHERE m.folder = ?1 AND m.id < ?2;

-- name: DeleteAllMessages :exec
DELETE FROM messages WHERE folder = ?;

-- name: LastMsgidIgnoringSeen :one
SELECT CAST(MAX(id) AS INT) FROM messages AS m WHERE m.folder = ?1;
