-- name: ListUsers :many
SELECT * FROM users;

-- name: DeleteUser :exec
DELETE FROM users WHERE login = ?;

-- name: AddFolder :exec
INSERT INTO folders (name) VALUES (?);

-- name: ListFolders :many
SELECT * FROM folders;

-- name: GetFolder :one
SELECT * FROM folders WHERE name = ?;

-- name: DeleteFolder :exec
DELETE FROM folders WHERE name = ?;

-- name: AddOwner :exec
INSERT INTO owners (folder, login) VALUES (?, ?);

-- name: ListOwners :many
SELECT * FROM owners;

-- name: GetOwner :one
SELECT * FROM owners WHERE folder = ? AND login = ?;

-- name: GetOwners :many
SELECT * FROM owners WHERE folder = ?;

-- name: DeleteOwner :exec
DELETE FROM owners WHERE folder = ? AND login = ?;

-- name: AddMessage :exec
INSERT INTO messages (id, folder) VALUES (?, ?);

-- name: ListMessages :many
SELECT * FROM messages WHERE folder = ? ORDER BY id;

-- name: GetMessage :one
SELECT * FROM messages WHERE id = ? AND folder = ?;

-- name: DeleteMessage :exec
DELETE FROM messages WHERE id = ? AND folder = ?;

-- name: AddSeen :exec
INSERT INTO seen (folder, login, msgid) VALUES (?, ?, ?);

-- name: ListSeen :many
SELECT * FROM seen;

-- name: GetSeen :one
SELECT * FROM seen WHERE folder = ? AND login = ? AND msgid = ?;

-- name: DeleteSeen :exec
DELETE FROM seen WHERE folder = ? AND login = ? AND msgid = ?;

-- name: AddMark :exec
INSERT INTO marks (folder, login, msgid) VALUES (?, ?, ?);

-- name: ListMark :many
SELECT * FROM marks WHERE folder = ? AND login = ?;

-- name: GetMark :one
SELECT * FROM marks WHERE folder = ? AND login = ? AND msgid = ?;

-- name: DeleteMark :exec
DELETE FROM marks WHERE folder = ? AND login = ? AND msgid = ?;

-- name: AddFolderAccess :exec
INSERT INTO folder_access (login, folder) VALUES (?, ?);

-- name: ListFolderAccess :many
SELECT * FROM folder_access;

-- name: GetFolderAccess :one
SELECT * FROM folder_access WHERE login = ? AND folder = ?;

-- name: DeleteFolderAccess :exec
DELETE FROM folder_access WHERE login = ? AND folder = ?;

-- name: AddFolderConfig :exec
INSERT INTO folder_configs (login, folder) VALUES (?, ?);

-- name: ListFolderConfig :many
SELECT * FROM folder_configs;

-- name: GetFolderConfig :one
SELECT * FROM folder_configs WHERE login = ? AND folder = ?;

-- name: DeleteFolderConfig :exec
DELETE FROM folder_configs WHERE login = ? AND folder = ?;

-- name: AddSystem :exec
INSERT INTO system (name) VALUES (?);

-- name: GetSystem :one
SELECT * FROM system WHERE name = ?;
