// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.29.0
// source: standard.sql

package storage

import (
	"context"
)

const addFolder = `-- name: AddFolder :exec
INSERT INTO folders (name) VALUES (?)
`

func (q *Queries) AddFolder(ctx context.Context, name string) error {
	_, err := q.db.ExecContext(ctx, addFolder, name)
	return err
}

const addFolderAccess = `-- name: AddFolderAccess :exec
INSERT INTO folder_access (login, folder) VALUES (?, ?)
`

type AddFolderAccessParams struct {
	Login  string
	Folder string
}

func (q *Queries) AddFolderAccess(ctx context.Context, arg AddFolderAccessParams) error {
	_, err := q.db.ExecContext(ctx, addFolderAccess, arg.Login, arg.Folder)
	return err
}

const addFolderConfig = `-- name: AddFolderConfig :exec
INSERT INTO folder_configs (login, folder) VALUES (?, ?)
`

type AddFolderConfigParams struct {
	Login  string
	Folder string
}

func (q *Queries) AddFolderConfig(ctx context.Context, arg AddFolderConfigParams) error {
	_, err := q.db.ExecContext(ctx, addFolderConfig, arg.Login, arg.Folder)
	return err
}

const addMark = `-- name: AddMark :exec
INSERT INTO marks (folder, login, msgid) VALUES (?, ?, ?)
`

type AddMarkParams struct {
	Folder string
	Login  string
	Msgid  int64
}

func (q *Queries) AddMark(ctx context.Context, arg AddMarkParams) error {
	_, err := q.db.ExecContext(ctx, addMark, arg.Folder, arg.Login, arg.Msgid)
	return err
}

const addMessage = `-- name: AddMessage :exec
INSERT INTO messages (id, folder) VALUES (?, ?)
`

type AddMessageParams struct {
	ID     int64
	Folder string
}

func (q *Queries) AddMessage(ctx context.Context, arg AddMessageParams) error {
	_, err := q.db.ExecContext(ctx, addMessage, arg.ID, arg.Folder)
	return err
}

const addOwner = `-- name: AddOwner :exec
INSERT INTO owners (folder, login) VALUES (?, ?)
`

type AddOwnerParams struct {
	Folder string
	Login  string
}

func (q *Queries) AddOwner(ctx context.Context, arg AddOwnerParams) error {
	_, err := q.db.ExecContext(ctx, addOwner, arg.Folder, arg.Login)
	return err
}

const addSeen = `-- name: AddSeen :exec
INSERT INTO seen (folder, login, msgid) VALUES (?, ?, ?)
`

type AddSeenParams struct {
	Folder string
	Login  string
	Msgid  int64
}

func (q *Queries) AddSeen(ctx context.Context, arg AddSeenParams) error {
	_, err := q.db.ExecContext(ctx, addSeen, arg.Folder, arg.Login, arg.Msgid)
	return err
}

const addSystem = `-- name: AddSystem :exec
INSERT INTO system (name) VALUES (?)
`

func (q *Queries) AddSystem(ctx context.Context, name string) error {
	_, err := q.db.ExecContext(ctx, addSystem, name)
	return err
}

const deleteFolder = `-- name: DeleteFolder :exec
DELETE FROM folders WHERE name = ?
`

func (q *Queries) DeleteFolder(ctx context.Context, name string) error {
	_, err := q.db.ExecContext(ctx, deleteFolder, name)
	return err
}

const deleteFolderAccess = `-- name: DeleteFolderAccess :exec
DELETE FROM folder_access WHERE login = ? AND folder = ?
`

type DeleteFolderAccessParams struct {
	Login  string
	Folder string
}

func (q *Queries) DeleteFolderAccess(ctx context.Context, arg DeleteFolderAccessParams) error {
	_, err := q.db.ExecContext(ctx, deleteFolderAccess, arg.Login, arg.Folder)
	return err
}

const deleteFolderConfig = `-- name: DeleteFolderConfig :exec
DELETE FROM folder_configs WHERE login = ? AND folder = ?
`

type DeleteFolderConfigParams struct {
	Login  string
	Folder string
}

func (q *Queries) DeleteFolderConfig(ctx context.Context, arg DeleteFolderConfigParams) error {
	_, err := q.db.ExecContext(ctx, deleteFolderConfig, arg.Login, arg.Folder)
	return err
}

const deleteMark = `-- name: DeleteMark :exec
DELETE FROM marks WHERE folder = ? AND login = ? AND msgid = ?
`

type DeleteMarkParams struct {
	Folder string
	Login  string
	Msgid  int64
}

func (q *Queries) DeleteMark(ctx context.Context, arg DeleteMarkParams) error {
	_, err := q.db.ExecContext(ctx, deleteMark, arg.Folder, arg.Login, arg.Msgid)
	return err
}

const deleteMessage = `-- name: DeleteMessage :exec
DELETE FROM messages WHERE id = ? AND folder = ?
`

type DeleteMessageParams struct {
	ID     int64
	Folder string
}

func (q *Queries) DeleteMessage(ctx context.Context, arg DeleteMessageParams) error {
	_, err := q.db.ExecContext(ctx, deleteMessage, arg.ID, arg.Folder)
	return err
}

const deleteOwner = `-- name: DeleteOwner :exec
DELETE FROM owners WHERE folder = ? AND login = ?
`

type DeleteOwnerParams struct {
	Folder string
	Login  string
}

func (q *Queries) DeleteOwner(ctx context.Context, arg DeleteOwnerParams) error {
	_, err := q.db.ExecContext(ctx, deleteOwner, arg.Folder, arg.Login)
	return err
}

const deleteSeen = `-- name: DeleteSeen :exec
DELETE FROM seen WHERE folder = ? AND login = ? AND msgid = ?
`

type DeleteSeenParams struct {
	Folder string
	Login  string
	Msgid  int64
}

func (q *Queries) DeleteSeen(ctx context.Context, arg DeleteSeenParams) error {
	_, err := q.db.ExecContext(ctx, deleteSeen, arg.Folder, arg.Login, arg.Msgid)
	return err
}

const deleteUser = `-- name: DeleteUser :exec
DELETE FROM users WHERE login = ?
`

func (q *Queries) DeleteUser(ctx context.Context, login string) error {
	_, err := q.db.ExecContext(ctx, deleteUser, login)
	return err
}

const getFolder = `-- name: GetFolder :one
SELECT name, "always", brief, description, notify, readnew, shownew, system, expire, visibility, create_at, update_at FROM folders WHERE name = ?
`

func (q *Queries) GetFolder(ctx context.Context, name string) (Folder, error) {
	row := q.db.QueryRowContext(ctx, getFolder, name)
	var i Folder
	err := row.Scan(
		&i.Name,
		&i.Always,
		&i.Brief,
		&i.Description,
		&i.Notify,
		&i.Readnew,
		&i.Shownew,
		&i.System,
		&i.Expire,
		&i.Visibility,
		&i.CreateAt,
		&i.UpdateAt,
	)
	return i, err
}

const getFolderAccess = `-- name: GetFolderAccess :one
SELECT login, folder FROM folder_access WHERE login = ? AND folder = ?
`

type GetFolderAccessParams struct {
	Login  string
	Folder string
}

func (q *Queries) GetFolderAccess(ctx context.Context, arg GetFolderAccessParams) (FolderAccess, error) {
	row := q.db.QueryRowContext(ctx, getFolderAccess, arg.Login, arg.Folder)
	var i FolderAccess
	err := row.Scan(&i.Login, &i.Folder)
	return i, err
}

const getFolderConfig = `-- name: GetFolderConfig :one
SELECT login, folder, "always", alert FROM folder_configs WHERE login = ? AND folder = ?
`

type GetFolderConfigParams struct {
	Login  string
	Folder string
}

func (q *Queries) GetFolderConfig(ctx context.Context, arg GetFolderConfigParams) (FolderConfig, error) {
	row := q.db.QueryRowContext(ctx, getFolderConfig, arg.Login, arg.Folder)
	var i FolderConfig
	err := row.Scan(
		&i.Login,
		&i.Folder,
		&i.Always,
		&i.Alert,
	)
	return i, err
}

const getMark = `-- name: GetMark :one
SELECT login, folder, msgid FROM marks WHERE folder = ? AND login = ? AND msgid = ?
`

type GetMarkParams struct {
	Folder string
	Login  string
	Msgid  int64
}

func (q *Queries) GetMark(ctx context.Context, arg GetMarkParams) (Mark, error) {
	row := q.db.QueryRowContext(ctx, getMark, arg.Folder, arg.Login, arg.Msgid)
	var i Mark
	err := row.Scan(&i.Login, &i.Folder, &i.Msgid)
	return i, err
}

const getMessage = `-- name: GetMessage :one
SELECT id, folder, author, subject, message, permanent, shutdown, expiration, create_at, update_at FROM messages WHERE id = ? AND folder = ?
`

type GetMessageParams struct {
	ID     int64
	Folder string
}

func (q *Queries) GetMessage(ctx context.Context, arg GetMessageParams) (Message, error) {
	row := q.db.QueryRowContext(ctx, getMessage, arg.ID, arg.Folder)
	var i Message
	err := row.Scan(
		&i.ID,
		&i.Folder,
		&i.Author,
		&i.Subject,
		&i.Message,
		&i.Permanent,
		&i.Shutdown,
		&i.Expiration,
		&i.CreateAt,
		&i.UpdateAt,
	)
	return i, err
}

const getOwner = `-- name: GetOwner :one
SELECT folder, login, create_at, update_at FROM owners WHERE folder = ? AND login = ?
`

type GetOwnerParams struct {
	Folder string
	Login  string
}

func (q *Queries) GetOwner(ctx context.Context, arg GetOwnerParams) (Owner, error) {
	row := q.db.QueryRowContext(ctx, getOwner, arg.Folder, arg.Login)
	var i Owner
	err := row.Scan(
		&i.Folder,
		&i.Login,
		&i.CreateAt,
		&i.UpdateAt,
	)
	return i, err
}

const getOwners = `-- name: GetOwners :many
SELECT folder, login, create_at, update_at FROM owners WHERE folder = ?
`

func (q *Queries) GetOwners(ctx context.Context, folder string) ([]Owner, error) {
	rows, err := q.db.QueryContext(ctx, getOwners, folder)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Owner
	for rows.Next() {
		var i Owner
		if err := rows.Scan(
			&i.Folder,
			&i.Login,
			&i.CreateAt,
			&i.UpdateAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getSeen = `-- name: GetSeen :one
SELECT login, folder, msgid, create_at FROM seen WHERE folder = ? AND login = ? AND msgid = ?
`

type GetSeenParams struct {
	Folder string
	Login  string
	Msgid  int64
}

func (q *Queries) GetSeen(ctx context.Context, arg GetSeenParams) (Seen, error) {
	row := q.db.QueryRowContext(ctx, getSeen, arg.Folder, arg.Login, arg.Msgid)
	var i Seen
	err := row.Scan(
		&i.Login,
		&i.Folder,
		&i.Msgid,
		&i.CreateAt,
	)
	return i, err
}

const getSystem = `-- name: GetSystem :one
SELECT name, default_expire, expire_limit FROM system WHERE name = ?
`

func (q *Queries) GetSystem(ctx context.Context, name string) (System, error) {
	row := q.db.QueryRowContext(ctx, getSystem, name)
	var i System
	err := row.Scan(&i.Name, &i.DefaultExpire, &i.ExpireLimit)
	return i, err
}

const listFolderAccess = `-- name: ListFolderAccess :many
SELECT login, folder FROM folder_access
`

func (q *Queries) ListFolderAccess(ctx context.Context) ([]FolderAccess, error) {
	rows, err := q.db.QueryContext(ctx, listFolderAccess)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []FolderAccess
	for rows.Next() {
		var i FolderAccess
		if err := rows.Scan(&i.Login, &i.Folder); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listFolderConfig = `-- name: ListFolderConfig :many
SELECT login, folder, "always", alert FROM folder_configs
`

func (q *Queries) ListFolderConfig(ctx context.Context) ([]FolderConfig, error) {
	rows, err := q.db.QueryContext(ctx, listFolderConfig)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []FolderConfig
	for rows.Next() {
		var i FolderConfig
		if err := rows.Scan(
			&i.Login,
			&i.Folder,
			&i.Always,
			&i.Alert,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listFolders = `-- name: ListFolders :many
SELECT name, "always", brief, description, notify, readnew, shownew, system, expire, visibility, create_at, update_at FROM folders
`

func (q *Queries) ListFolders(ctx context.Context) ([]Folder, error) {
	rows, err := q.db.QueryContext(ctx, listFolders)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Folder
	for rows.Next() {
		var i Folder
		if err := rows.Scan(
			&i.Name,
			&i.Always,
			&i.Brief,
			&i.Description,
			&i.Notify,
			&i.Readnew,
			&i.Shownew,
			&i.System,
			&i.Expire,
			&i.Visibility,
			&i.CreateAt,
			&i.UpdateAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listMark = `-- name: ListMark :many
SELECT login, folder, msgid FROM marks WHERE folder = ? AND login = ?
`

type ListMarkParams struct {
	Folder string
	Login  string
}

func (q *Queries) ListMark(ctx context.Context, arg ListMarkParams) ([]Mark, error) {
	rows, err := q.db.QueryContext(ctx, listMark, arg.Folder, arg.Login)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Mark
	for rows.Next() {
		var i Mark
		if err := rows.Scan(&i.Login, &i.Folder, &i.Msgid); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listMessages = `-- name: ListMessages :many
SELECT id, folder, author, subject, message, permanent, shutdown, expiration, create_at, update_at FROM messages WHERE folder = ? ORDER BY id
`

func (q *Queries) ListMessages(ctx context.Context, folder string) ([]Message, error) {
	rows, err := q.db.QueryContext(ctx, listMessages, folder)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Message
	for rows.Next() {
		var i Message
		if err := rows.Scan(
			&i.ID,
			&i.Folder,
			&i.Author,
			&i.Subject,
			&i.Message,
			&i.Permanent,
			&i.Shutdown,
			&i.Expiration,
			&i.CreateAt,
			&i.UpdateAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listOwners = `-- name: ListOwners :many
SELECT folder, login, create_at, update_at FROM owners
`

func (q *Queries) ListOwners(ctx context.Context) ([]Owner, error) {
	rows, err := q.db.QueryContext(ctx, listOwners)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Owner
	for rows.Next() {
		var i Owner
		if err := rows.Scan(
			&i.Folder,
			&i.Login,
			&i.CreateAt,
			&i.UpdateAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listSeen = `-- name: ListSeen :many
SELECT login, folder, msgid, create_at FROM seen
`

func (q *Queries) ListSeen(ctx context.Context) ([]Seen, error) {
	rows, err := q.db.QueryContext(ctx, listSeen)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Seen
	for rows.Next() {
		var i Seen
		if err := rows.Scan(
			&i.Login,
			&i.Folder,
			&i.Msgid,
			&i.CreateAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listUsers = `-- name: ListUsers :many
SELECT login, name, admin, moderator, alert, disabled, last_login, create_at, update_at FROM users
`

func (q *Queries) ListUsers(ctx context.Context) ([]User, error) {
	rows, err := q.db.QueryContext(ctx, listUsers)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []User
	for rows.Next() {
		var i User
		if err := rows.Scan(
			&i.Login,
			&i.Name,
			&i.Admin,
			&i.Moderator,
			&i.Alert,
			&i.Disabled,
			&i.LastLogin,
			&i.CreateAt,
			&i.UpdateAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}
