// Package repl implements the main event loop.
package repl

import (
	"fmt"
	"path"

	"github.com/adrg/xdg"
	"github.com/chzyer/readline"
)

// Loop is the main event loop.
func Loop(user string) error {
	fmt.Printf("TODO: get config for user %s using xdg.\n", user)
	rl, err := readline.NewEx(
		&readline.Config{
			Prompt:      "BULLETIN> ",
			HistoryFile: path.Join(xdg.ConfigHome, "BULLETIN", fmt.Sprintf("%s.history", user)),
			// TODO: AutoComplete:    completer,
			InterruptPrompt:   "^C",
			EOFPrompt:         "EXIT",
			HistorySearchFold: true,
		})
	if err != nil {
		return err
	}
	defer rl.Close()

	for {
		line, err := rl.Readline()
		if err != nil {
			if err.Error() == "Interrupt" {
				commands.ParseAndRun("QUIT")
			} else if err.Error() == "EOF" {
				commands.ParseAndRun("EXIT")
			}
			return err
		}
		if len(line) == 0 {
			continue
		}
		err = commands.ParseAndRun(line)
		if err != nil {
			return err
		}
	}
}
