package folders

import (
	"context"
	"errors"
	"time"

	"git.lyda.ie/kevin/bulletin/storage"
	"git.lyda.ie/kevin/bulletin/this"
)

// CreateMessage creates a new folder.
func CreateMessage(author, subject, message, folder string, permanent, shutdown int, expiration *time.Time) error {
	ctx := context.TODO()
	if expiration == nil {
		days, err := this.Q.GetFolderExpire(ctx, folder)
		if err != nil {
			return err
		}
		if days <= 0 {
			// TODO: Get from site config.
			days = 14
		}
		exp := time.Now().AddDate(0, 0, int(days))
		expiration = &exp
	}
	// TODO: replace _ with rows and check.
	err := this.Q.CreateMessage(ctx, storage.CreateMessageParams{
		Folder:     folder,
		Folder_2:   folder,
		Author:     author,
		Subject:    subject,
		Message:    message,
		Permanent:  int64(permanent),
		Shutdown:   int64(shutdown),
		Expiration: *expiration,
	})
	// TODO: process this error a bit more to give a better error message.
	return err
}

// ReadMessage reads a message for a user.
func ReadMessage(login, folder string, msgid int64) (*storage.Message, error) {
	ctx := context.TODO()
	msg, err := this.Q.ReadMessage(ctx, storage.ReadMessageParams{
		Folder: folder,
		ID:     msgid,
	})
	if err != nil {
		return nil, err
	}

	if msg.ID != int64(msgid) || msgid == 0 {
		return nil, errors.New("Specified message was not found")
	}
	err = this.Q.SetMessageSeen(ctx, storage.SetMessageSeenParams{
		Login:  login,
		Folder: folder,
		Msgid:  int64(msgid),
	})

	return &msg, nil
}

// ListMessages lists messages.
func ListMessages(folder string) ([]storage.ListMessagesRow, error) {
	ctx := context.TODO()
	// TODO: options aren't implemented - need to set them?
	rows, err := this.Q.ListMessages(ctx, folder)
	return rows, err
}
