/*
Package ask provides routines to ask questions of users. It handles
getting a line of text, getting a choice from a liat and other things.
*/
package ask

import "github.com/chzyer/readline"

// GetLine gets a line.
func GetLine(prompt string) (string, error) {
	rl, err := readline.New(prompt)
	if err != nil {
		return "", err
	}
	defer rl.Close()
	line, err := rl.Readline()
	return line, err
}
