package storage

import (
	"errors"

	"github.com/jmoiron/sqlx"

	// Included to connect to sqlite.
	_ "github.com/golang-migrate/migrate/v4/database/sqlite"
	_ "modernc.org/sqlite"
)

// Open opens the bulletin database.
func Open(dbfile string) (*sqlx.DB, error) {
	db, err := sqlx.Connect("sqlite", "file://"+dbfile+"?_pragma=foreign_keys(1)")
	if err != nil {
		return nil, errors.New("bulletin database problem")
	}
	return db, nil
}
