package storage

import (
	"fmt"
	"strings"
	"time"
)

// Full renders a message.
func (m *Message) Full() string {
	buf := &strings.Builder{}
	changed := "*"
	if m.CreateAt.Compare(m.UpdateAt) == 0 {
		changed = ""
	}
	fmt.Fprintf(buf, "From: \"%s\" %s%s\n", m.Author,
		m.CreateAt.Format("02-JAN-2006 15:04:05"), changed)
	fmt.Fprintf(buf, "To: %s\n", m.Folder)
	fmt.Fprintf(buf, "Subj: %s\n\n", m.Subject)
	fmt.Fprintf(buf, "%s\n", m.Message)

	return buf.String()
}

// Short renders a message.
func (m *Message) Short(expire bool) string {
	var t time.Time
	if expire {
		t = m.Expiration
	} else {
		t = m.CreateAt
	}
	ts := t.Format("2006-05-04 15:02:01")
	return fmt.Sprintf("%4d %-43s %-12s %-10s\n", m.ID, m.Subject, m.Author, ts)
}
