// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.29.0
// source: messages.sql

package storage

import (
	"context"
	"time"
)

const createMessage = `-- name: CreateMessage :exec
INSERT INTO messages (
  id, folder, author, subject, message, permanent, shutdown, expiration
) VALUES (
  (SELECT COALESCE(MAX(id), 0) + 1 FROM messages AS m WHERE m.folder = ?),
  ?, ?, ?, ?, ?, ?, ?)
`

type CreateMessageParams struct {
	Folder     string
	Folder_2   string
	Author     string
	Subject    string
	Message    string
	Permanent  int64
	Shutdown   int64
	Expiration time.Time
}

func (q *Queries) CreateMessage(ctx context.Context, arg CreateMessageParams) error {
	_, err := q.db.ExecContext(ctx, createMessage,
		arg.Folder,
		arg.Folder_2,
		arg.Author,
		arg.Subject,
		arg.Message,
		arg.Permanent,
		arg.Shutdown,
		arg.Expiration,
	)
	return err
}

const getFirstMessageID = `-- name: GetFirstMessageID :one
SELECT id FROM messages WHERE folder = ? and id = MIN(id) GROUP BY folder
`

func (q *Queries) GetFirstMessageID(ctx context.Context, folder string) (int64, error) {
	row := q.db.QueryRowContext(ctx, getFirstMessageID, folder)
	var id int64
	err := row.Scan(&id)
	return id, err
}

const listMessages = `-- name: ListMessages :many
SELECT id, folder, author, subject, message, expiration, create_at, update_at
FROM messages
WHERE folder = ?
`

type ListMessagesRow struct {
	ID         int64
	Folder     string
	Author     string
	Subject    string
	Message    string
	Expiration time.Time
	CreateAt   time.Time
	UpdateAt   time.Time
}

func (q *Queries) ListMessages(ctx context.Context, folder string) ([]ListMessagesRow, error) {
	rows, err := q.db.QueryContext(ctx, listMessages, folder)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []ListMessagesRow
	for rows.Next() {
		var i ListMessagesRow
		if err := rows.Scan(
			&i.ID,
			&i.Folder,
			&i.Author,
			&i.Subject,
			&i.Message,
			&i.Expiration,
			&i.CreateAt,
			&i.UpdateAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const markMessage = `-- name: MarkMessage :exec
INSERT INTO mark (login, folder, msgid) VALUES (?, ?, ?)
`

type MarkMessageParams struct {
	Login  string
	Folder string
	Msgid  int64
}

func (q *Queries) MarkMessage(ctx context.Context, arg MarkMessageParams) error {
	_, err := q.db.ExecContext(ctx, markMessage, arg.Login, arg.Folder, arg.Msgid)
	return err
}

const setMessageSeen = `-- name: SetMessageSeen :exec
INSERT INTO seen (login, folder, msgid) VALUES (?, ?, ?)
`

type SetMessageSeenParams struct {
	Login  string
	Folder string
	Msgid  int64
}

func (q *Queries) SetMessageSeen(ctx context.Context, arg SetMessageSeenParams) error {
	_, err := q.db.ExecContext(ctx, setMessageSeen, arg.Login, arg.Folder, arg.Msgid)
	return err
}
