-- name: CreateFolder :exec
  INSERT INTO folders (
  name, always, brief, description, notify, readnew, shownew, system,
  expire, visibility
) VALUES (
  ?, ?, ?, ?, ?, ?, ?, ?, ?, ?
);

-- name: ListFolderForAdmin :many
SELECT f.name, count(m.id) as count, f.description
FROM folders AS f LEFT JOIN messages AS m ON f.name = m.folder
GROUP By f.name
ORDER BY f.name;

-- name: ListFolder :many
SELECT f.name, count(m.id) as count, f.description
FROM folders AS f LEFT JOIN messages AS m ON f.name = m.folder
GROUP By f.name
ORDER BY f.name;

-- name: FindFolderExact :one
SELECT name FROM folders where name = ?;

-- name: FindFolderPrefix :one
SELECT name FROM folders where name LIKE ?
ORDER BY name
LIMIT 1;

-- name: IsFolderAccess :one
SELECT 1 FROM folders AS f LEFT JOIN owners AS c ON f.name = c.folder
  WHERE f.name = ? AND (f.visibility = 0 OR c.OWNER = ?);

-- name: IsFolderOwner :one
SELECT 1 FROM folders AS f LEFT JOIN owners AS c ON f.name = c.folder
  WHERE f.name = ? AND c.OWNER = ?;

-- name: DeleteFolder :exec
DELETE FROM folders WHERE name=?;

-- name: GetFolderExpire :one
SELECT expire FROM folders WHERE name = ?;
