// Package users manages users.
package users

import (
	"errors"
	"fmt"
	"strings"

	_ "modernc.org/sqlite" // Loads sqlite driver.
)

// ValidLogin makes sure that an account name is a valid name.
func ValidLogin(login string) error {
	if login == "" {
		return errors.New("empty account is invalid")
	}
	if strings.ContainsAny(login, "./") {
		return fmt.Errorf("account name '%s' is invalid", login)
	}
	return nil
}
