package dclish

import (
	"strings"
	"unicode"
)

// Completer command completer type.
type Completer struct {
	commands []string
	flags    map[string][]string
}

// NewCompleter creates a new completer.
func NewCompleter(commands Commands) Completer {
	comps := []string{}
	flags := map[string][]string{}
	for c := range commands {
		comps = append(comps, c)
		if len(commands[c].Commands) > 0 {
			subcommands := commands[c].Commands
			for subc := range subcommands {
				fullc := c + " " + subc
				comps = append(comps, fullc)
				flags[fullc] = []string{}
				if subcommands[subc].Flags != nil {
					for f := range subcommands[subc].Flags {
						flags[fullc] = append(flags[fullc], f)
					}
				}
			}
		}
		flags[c] = []string{}
		if commands[c].Flags != nil {
			for f := range commands[c].Flags {
				flags[c] = append(flags[c], f)
			}
		}
	}
	return Completer{
		commands: comps,
		flags:    flags,
	}
}

// Do return a list of possible completions.
func (c Completer) Do(line []rune, pos int) ([][]rune, int) {
	// Nothing typed in.
	if pos == 0 {
		newline := make([][]rune, len(c.commands))
		for i := range c.commands {
			newline[i] = []rune(c.commands[i])
		}
		return newline, pos
	}

	// Command partially typed in.
	newline := [][]rune{}
	cmd := strings.ToUpper(string(line[0:pos]))
	lower := false
	if unicode.IsLower(line[0]) {
		lower = true
	}
	for i := range c.commands {
		if strings.HasPrefix(c.commands[i], cmd) {
			rest := strings.Replace(c.commands[i], cmd, "", 1)
			if lower {
				newline = append(newline, []rune(strings.ToLower(rest)))
			} else {
				newline = append(newline, []rune(rest))
			}
		}
	}
	if len(newline) > 0 {
		return newline, pos
	}

	// Command completely typed in.
	return newline, pos
}
