package this

import (
	"fmt"
	"sort"
	"strings"
	"time"

	"git.lyda.ie/kevin/bulletin/pager"
	"git.lyda.ie/kevin/bulletin/storage"
)

// ShowBroadcast print broadcast and shutdown messages.
func ShowBroadcast() {
	ctx := storage.Context()
	User.LastActivity = time.Now().UTC()
	msgs, _ := Q.GetBroadcasts(ctx, User.LastActivity)
	if len(msgs) > 0 {
		fmt.Println("BROADCAST MSG START")
		for i := range msgs {
			fmt.Printf("\n%s\n", msgs[i])
		}
		fmt.Println("BROADCAST MSG END")
	}
	Q.UpdateLastActivity(ctx, User.LastActivity, User.Login)
	Q.ReapBroadcasts(ctx)
}

// ShowAlerts print alert messages.
func ShowAlerts(doReadNew bool) {
	ctx := storage.Context()
	alerts, err := Q.GetAlertMessages(ctx, User.Name, User.LastActivity)
	if err != nil {
		fmt.Printf("ERROR: failed to get alerts: %s.\n", err)
	}
	briefs := map[string]int{}
	shownew := &strings.Builder{}
	readnew := &strings.Builder{}
	for i := range alerts {
		switch storage.EffectiveAlert(alerts[i].UserAlert, alerts[i].FolderAlert) {
		case storage.AlertBrief:
			briefs[alerts[i].Message.Folder]++
		case storage.AlertShowNew:
			fmt.Fprintf(shownew, "%s", alerts[i].Message.AlertLine())
		case storage.AlertReadNew:
			if doReadNew {
				Q.SetMessageSeen(ctx, User.Login, Folder.Name, alerts[i].Message.ID)
				fmt.Fprintf(readnew, "%s\n", alerts[i].Message.String())
			}
		}
	}

	activity := false
	if len(briefs) > 0 {
		activity = true
		keys := make([]string, len(briefs))
		i := 0
		for key := range briefs {
			keys[i] = key
			i++
		}
		sort.Strings(keys)
		for _, key := range keys {
			fmt.Printf("There are %d new messages in %s\n", briefs[key], key)
		}
	}
	if shownew.Len() > 0 {
		activity = true
		fmt.Println(shownew.String())
	}
	if readnew.Len() > 0 {
		activity = true
		pager.Pager(readnew.String())
	}
	if !activity {
		fmt.Println("No new activity found.")
	}

}
