// Package users manages users.
package users

import (
	"errors"
	"fmt"
	"strings"

	"git.lyda.ie/kevin/bulletin/storage"
	_ "modernc.org/sqlite" // Loads sqlite driver.
)

// ValidLogin makes sure that an account name is a valid name.
func ValidLogin(login string) error {
	if login == "" {
		return errors.New("empty account is invalid")
	}
	if strings.ContainsAny(login, "./%:") {
		return fmt.Errorf("account name '%s' is invalid", login)
	}
	return nil
}

// ValidExistingLogin makes sure that an account name is a valid name.
func ValidExistingLogin(q *storage.Queries, login string) (storage.User, error) {
	u := storage.User{}
	if login == "" {
		return u, errors.New("empty account is invalid")
	}
	login = strings.ToUpper(login)
	if strings.ContainsAny(login, "./%:") {
		return u, fmt.Errorf("account name '%s' is invalid", login)
	}
	ctx := storage.Context()
	return q.GetUser(ctx, login)
}
