// Package repl implements the main event loop.
package repl

import "git.lyda.ie/kevin/bulletin/dclish"

var commands = dclish.Commands{
	"ADD": {
		Description: `Adds a  message to the specified  folder. A file can  be specified which
contains  the message.  Otherwise, BULLETIN  will prompt  for the  text.
BULLETIN will  ask for an  expiration date and  a header to  contain the
topic of the message.

  Format:
    ADD [file-name]`,
		MaxArgs: 1,
		Action:  ActionAdd,
		Flags: dclish.Flags{
			"/ALL": {
				Description: `  This  option  is  restricted  to  privileged  users.  It  is  used  in
  conjunction with the /BROADCAST qualifier. If specified, all terminals
  are sent the message. Otherwise, only users are sent the message.`,
			},
			"/BELL": {
				Description: `  This  option  is  restricted  to  privileged  users.  It  is  used  in
  conjunction with the  /BROADCAST qualifier. If specified,  the bell is
  rung on the terminals when the message is broadcasted.`,
			},
			"/BROADCAST": {
				Description: `  This option is restricted to  privileged users and SYSTEM folders.  If
  specified,  a message  is both  stored  and broadcasted  to all  users
  logged in  at the  time. If the  folder is remote,  a message  will be
  broadcast  on all  nodes which  are connected  to that  folder, unless
  /LOCAL is specified. A node which  does not have BULLCP running cannot
  have a message broadcasted to it, (even  though it is able to create a
  remote folder).

  See also /ALL and /BELL.`,
			},
			"/EDIT": {
				Description: `/[NO]EDIT

  Determines whether  or not the editor  is invoked to edit  the message
  you are adding. /EDIT is the default.`,
				Default: "true",
			},
			"/EXPIRATION": {
				Description: `/EXPIRATION=time

  Specifies the time at which the message is to expire.  Either absolute
  time: dd-mmm-yyyy, or delta time: dddd can be used.`,
				OptArg: true,
			},
			"/EXTRACT": {
				Description: `  Specifies  that the  text of  the  previously read  message should  be
  included at  the beginning  of the new  message. The  previous message
  must be  in the same  folder. This qualifier  is valid only  when used
  with /EDIT. The text is indented with > at the beginning of each line.
  This can be suppressed with /NOINDENT.`,
			},
			"/FOLDER": {
				Description: `/FOLDER=(foldername,[...])

  Specifies the foldername into which the message is to  be  added.   Does
  not  change the current selected folder.

  You can specify logical names which translate  to  one  or  more  folder
  names.   I.e.   $  DEFINE ALL_FOLDERS "VAX1,VAX2,VAX3", and then specify
  ALL_FOLDERS after /FOLDER=.  Note that the quotation marks are required.`,
				OptArg: true,
			},
			"/INDENT": {
				Description: `  See /EXTRACT for information on this qualifier.

  Defaults to set - use /NOINDENT to suppress.`,
				Default: "true",
			},
			"/SIGNATURE": {
				Description: `  Specifies to automatically appended signature, if one exists.
  Signatures are appended for postings to mailing lists and to responds.
  See the help topic POST Signature_file for signature information.

  Defaults to set - use /NOSIGNATURE to suppress.`,
				Default: "true",
			},
			"/PERMANENT": {
				Description: `  If  specified, message  will be  a  permanent message  and will  never
  expire. If an  expiration limit is set, then permament  is not allowed
  unless user has privileges.`,
			},
			"/SUBJECT": {
				Description: `/SUBJECT=description

  Specifies the subject of the message to be added.`,
				OptArg: true,
			},
			"/SHUTDOWN": {
				Description: `  This option is restricted to privileged users.  If specified, message
  will be automatically deleted after a computer shutdown has occurred.
  This option is restricted to SYSTEM folders.

  If the  bulletin files are  shared between cluster nodes,  the message
  will be deleted after the node on which the message was submitted from
  is rebooted. If  you wish the message to be  deleted after a different
  node reboots, you have the option of specifying that node name.

  NOTE: If  the folder is a  remote folder, the message  will be deleted
  after the remote node reboots, not the node from which the message was
  added. The nodename cannot be specified with a remote folder.`,
				OptArg: true,
			},
			"/SYSTEM": {
				Description: `  This option is restricted to privileged users.   If specified, message
  is both saved in the folder and  displayed in full as a system message
  when a user logs in. System messages should be as brief as possible to
  avoid  the  possibility that  system  messages  could scroll  off  the
  screen. This option is restricted to SYSTEM folders.`,
			},
		},
	},
	"BACK": {
		Description: `Displays the message preceding the current message.`,
		Action:      ActionBack,
		Flags: dclish.Flags{
			"/EDIT": {
				Description: `/EDIT

  Specifies that the editor is to be used to read the message.  This is
  useful for scanning a long message.`,
			},
			"/HEADER": {
				Description: `/[NO]HEADER

  Specifies that if a message header exists, the header will be shown.
  If /HEADER or /NOHEADER is specified, the setting will apply for all
  further reads in the selected folder.  The default is /HEADER.`,
			},
		},
	},
	"CHANGE": {
		Description: `Replaces or modifies existing stored  message. This is for changing part
or all  of a  message without  causing users who  have already  seen the
message to be notified of it a second time. You can select qualifiers so
that either the  message text, expiration date, or the  header are to be
changed.  If no  qualifier  is  added, the  default  is  that all  these
parameters  are to  be changed.  If the  text of  the message  is to  be
changed, a file can be specified  which contains the text. If the editor
is used for  changing the text, the old message  text will be extracted.
This can be suppressed by the qualifier /NEW.

  Format:
    CHANGE [file-name]`,
		MaxArgs: 1,
		Action:  ActionChange,
		Flags: dclish.Flags{
			"/ALL": {
				Description: `  Makes  the  changes to  all  the  messages  in  the folder.  Only  the
  expiration date and  message headers can be changed  if this qualifier
  is specified.`,
			},
			"/EDIT": {
				Description: `/[NO]EDIT

  Determines whether  or not the editor  is invoked to edit  the message
  you are replacing. The old message text is read into the editor unless
  a file-name  or /NEW is  specified. /EDIT is  the default if  you have
  added /EDIT to your BULLETIN command line.`,
			},
			"/EXPIRATION": {
				Description: `/EXPIRATION[=time]

  Specifies the time at which the  message is to expire. Either absolute
  time: dd-mmm-yyyy,  or delta  time: dddd  can be used.  If no  time is
  specified, you will be prompted for the time.`,
				OptArg: true,
			},
			"/GENERAL": {
				Description: `  Specifies that the message is to be converted from a SYSTEM message to
  a GENERAL message.  This only applies to the GENERAL folder.`,
			},
			"/HEADER": {
				Description: `  Specifies  that the  message header  is to  be replaced.  You will  be
  prompted for the new message description.`,
			},
			"/NEW": {
				Description: `  If the editor is to be used for replacing the text of the message, NEW
  specifies not to read in the old  message text, and that a totally new
  text is to be read in.`,
			},
			"/NUMBER": {
				Description: `/NUMBER=message_number[-message_number1]

  Specifies the message or messages to be replaced. If this qualifier is
  omitted, the message that is presently  being read will be replaced. A
  range  of  messages  can  be specified,  i.e.  /NUMBER=1-5.  Only  the
  expiration  date and  message headers  can be  changed if  a range  is
  specified.

  The key words CURRENT and LAST can  also be specified in the range in,
  place of an actual number, i.e. CURRENT-LAST, 1-CURRENT, etc.`,
				OptArg: true,
			},
			"/PERMANENT": {
				Description: `  Specifies that the message is to be made permanent.`,
			},
			"/SHUTDOWN": {
				Description: `  Specifies  that the  message  is  to expire  after  the next  computer
  shutdown. This option is restricted to SYSTEM folders.`,
			},
			"/SUBJECT": {
				Description: `/SUBJECT=description

  Specifies the subject of the message to be added.`,
				OptArg: true,
			},
			"/SYSTEM": {
				Description: `  Specifies that the message  is to be made a SYSTEM  message. This is a
  privileged command and is restricted to SYSTEM folders.`,
			},
			"/TEXT": {
				Description: `  Specifies that the message text is to be replaced.`,
			},
		},
	},
	"COPY": {
		Description: `Copies a message to another folder  without deleting it from the current
folder.

  Format:
    COPY folder-name [message_number][-message_number1]

The folder-name is the name of the  folder to which the message is to be
copied to. Optionally, a range of messages which are to be copied can be
specified following the folder name, i.e. COPY NEWFOLDER 2-5.

The key words  CURRENT and LAST can  also be specified in  the range in,
place of an actual number, i.e. CURRENT-LAST, 1-CURRENT, etc.`,
		MinArgs: 1,
		MaxArgs: 2,
		Flags: dclish.Flags{
			"/ALL": {
				Description: `  Specifies to copy all the messages in the old folder.`,
			},
			"/HEADER": {
				Description: `/[NO]HEADER

  Valid  only if  destination folder  is  a news  group. Specifies  that
  header of  message is to  be included with the  text when the  text is
  copied. The default is /NOHEADER.`,
			},
			"/MERGE": {
				Description: `  Specifies that the  original date and time of the  copied messages are
  saved and that the messages  are placed in correct chronological order
  in the  new folder.  This operation  is lengthy if  the new  folder is
  large.`,
			},
			"/ORIGINAL": {
				Description: `  Specifies that  the owner of the  copied message will be  the original
  owner of the  message. The default is that the  copied message will be
  owned by the person copying the message.`,
			},
		},
	},
	"CREATE": {
		Description: `Creates a folder of messages.  This is similar to the folders in the VMS
MAIL utility.  Folders are often created so that messages of  a  similar
topic are grouped separately, or to restrict reading of certain messages
to  specified  users.   Once  created,  that  message  is  automatically
selected  (see information on SELECT command).  The commands that can be
used to modify the folder's characteristics  are:  MODIFY,  REMOVE,  SET
ACCESS, SET BBOARD, SET NODE, and SET SYSTEM.

  Format:
    CREATE folder-name

The  folder-name is limited to 25 letters and must not include spaces or
characters that are also invalid  in  filenames  (this  is  because  the
folder is stored in a file name created with the folder name).

NOTE:  Creation  of folders may be a restricted command if the installer
has  elected  to  install  it  as  such.   This  is  done  by  modifying
BULLCOM.CLD.`,
		Action:  ActionCreate,
		MinArgs: 1,
		MaxArgs: 1,
		Flags: dclish.Flags{
			"/ALWAYS": {
				Description: `  Specifies that  the  folder  has  the  ALWAYS  attribute.   This  causes
  messages  in  the  folder  to  be displayed differently when logging in.
  SYSTEM messages will be displayed every time a user logs in, rather than
  just  once.   Non-SYSTEM  message  will also be displayed every time (in
  whatever mode is selected, i.e. BRIEF, SHOWNEW, or  READNEW)  until  the
  user  actually  reads  that  message  (or a later one).  This feature is
  meant for messages which are very important, and thus you want  to  make
  sure they are read.`,
			},
			"/BRIEF": {
				Description: `  Specifies that all users automatically have BRIEF set for this  folder.
  Only a privileged user can use this qualifier.  (See HELP SET BRIEF for
  more information.)`,
			},
			"/DESCRIPTION": {
				Description: `/DESCRIPTION=description

  Specifies the description of the  folder, which is displayed using the
  SHOW FOLDER command.  If omitted, you are prompted for a description.`,
				OptArg: true,
			},
			"/EXPIRE": {
				Description: `/EXPIRE=days

  Sets the default number of days for messages to expire.

  Default value is 14.`,
				OptArg:  true,
				Default: "14",
			},
			"/ID": {
				Description: `  Designates  that the  name specified  as the  owner name  is a  rights
  identifier. The  creator's process must have  the identifier presently
  assigned to it.  Any process which has that identifier  assigned to it
  will be able to  control the folder as if it  were the folder's owner.
  This is used to allow more than one use to control a folder.`,
				OptArg: true,
			},
			"/NOTIFY": {
				Description: `  Specifies  that  all users  automatically  have  NOTIFY set  for  this
  folder. Only a  privileged user can use this qualifier.  (See HELP SET
  NOTIFY for more information.)`,
			},
			"/OWNER": {
				Description: `/OWNER=username

  Specifies the owner of the folder.  This is a privileged command.  See
  also /ID.`,
				OptArg: true,
			},
			"/PRIVATE": {
				Description: `  Specifies that the folder can only  be accessed by users who have been
  granted access via the SET ACCESS command. Note: This option uses ACLs
  and users who are granted access  must be entered into the Rights Data
  Base. If the RDB does not exist on your system, a privileged user will
  have to  create it. If  a user  is not in  the RDB, this  program will
  automatically enter the user into it (unless this feature was disabled
  during the compilation of this program). NOTE: See HELP SET ACCESS for
  more info.`,
			},
			"/READNEW": {
				Description: `  Specifies  that all  users  automatically have  READNEW  set for  this
  folder. Only a  privileged user can use this qualifier.  (See HELP SET
  READNEW for more information.)`,
			},
			"/SHOWNEW": {
				Description: `  Specifies  that all  users  automatically have  SHOWNEW  set for  this
  folder. Only a  privileged user can use this qualifier.  (See HELP SET
  SHOWNEW for more information.)`,
			},
			"/SEMIPRIVATE": {
				Description: `  Similar to  /PRIVATE, except that  the folder is restricted  only with
  respect  to adding  or  modifying  messages. All  users  can read  the
  folder.`,
			},
			"/SYSTEM": {
				Description: `  Specifies  that the  folder is  a SYSTEM  folder. A  SYSTEM folder  is
  allowed to have SYSTEM and SHUTDOWN  messages added to it. By default,
  the GENERAL folder is a SYSTEM folder. This is a privileged command.

  If this  is a remote  folder, /SYSTEM  cannot be specified  unless the
  folder at the other node is also a SYSTEM folder.`,
			},
		},
	},
	"CURRENT": {
		Description: `Displays the beginning of the message you are currently reading.  If
you  are  reading  a long message and want to display the first part
of the message again, you can enter the CURRENT command.

  Format:
    CURRENT`,
		Action: ActionCurrent,
		Flags: dclish.Flags{
			"/EDIT": {
				Description: `  Specifies that the editor  is to be used to read  the message. This is
  useful for scanning a long message.`,
			},
			"/HEADER": {
				Description: `/[NO]HEADER

  Specifies that if a message header exists, the header will be shown.
  If /HEADER or /NOHEADER is specified, the setting will apply for all
  further reads in the selected folder.  The default is /HEADER.`,
			},
		},
	},
	"DELETE": {
		Description: `Deletes the specified  message. If no message is  specified, the current
message is  deleted. Only the  original owner  or a privileged  user can
delete a message. Note that the  message is not deleted immediately, but
its expiration is set 15 minutes in  the future. This is to allow a user
to  recover the  message using  the UNDELETE  command.

  Format:
    DELETE [message_number][-message_number1]

The message's relative  number is found by the DIRECTORY  command. It is
possible  to  delete a  range  of  messages  by specifying  two  numbers
separated  by a  dash,  i.e.  DELETE 1-5.  However,  a  range cannot  be
specified if the folder is remote.

The key words  CURRENT and LAST can  also be specified in  the range in,
place of an actual number, i.e. CURRENT-LAST, 1-CURRENT, etc.`,
		MaxArgs: 1,
		Action:  ActionDelete,
		Flags: dclish.Flags{
			"/ALL": {
				Description: `  Specifies to delete all the messages in the folder.  Note:  This will
  not work for remote folders.  Only one message can be deleted from a
  remote folder at a time.`,
			},
		},
	},
	"DIRECTORY": {
		Description: `Lists a summary of the messages.  The message number, submitter's name,
date, and subject of each message is displayed.

  Format:
    DIRECTORY [folder]

If  a  folder is specified, that folder is selected before the directory
is listed.  Unless otherwise specified, listing starts  with  the  first
newest message.  If there are no new messages, listing will start at the
first message, or if a message has already been read, it will  start  at
that message.`,
		MaxArgs: 1,
		Action:  ActionDirectory,
		Flags: dclish.Flags{
			"/ALL": {
				Description: `  Lists all messages.  Used if the qualifiers /MARKED, /UNMARKED, /SEEN,
  or /UNSEEN were previously specified.`,
			},
			"/DESCRIBE ": {
				Description: `  Valid when  used with  /FOLDERS. Specifies  to include  description of
  folder.`,
			},
			"/EXPIRATION": {
				Description: `  Shows the message's expiration date rather than the creation date.`,
			},
			"/END": {
				Description: `/END=message_number

  Indicates the last message number you want to display.`,
				OptArg: true,
			},
			"/FOLDERS": {
				Description: `  Lists  the available  message  folders. Shows  last  message date  and
  number  of messages  in folder.  An  asterisk (*)  next to  foldername
  indicates that there are unread messages in that folder.`,
			},
			"/MARKED": {
				Description: `  Lists messages that have been  marked (indicated by an asterisk). This
  is equivalent to  selecting the folder with /MARKED,  i.e. only marked
  messages will be  shown and be able  to be read. To  see all messages,
  use either /ALL, or reselect the folder.`,
			},
			"/UNMARKED": {
				Description: `  Lists  messages  that  have  not  been  marked  (marked  messages  are
  indicated by an asterisk). Using  /UNMARKED is equivalent to selecting
  the folder with  /UNMARKED, i.e. only unmarked messages  will be shown
  and be  able to  be read.  To see  all messages,  use either  /ALL, or
  reselect the folder.`,
			},
			"/SEEN": {
				Description: `  Lists messages that have been seen (indicated by a greater than sign).
  Using /SEEN  is equivalent  to selecting the  folder with  /SEEN, i.e.
  only seen messages  will be shown and  be able to be read.  To see all
  messages, use either /ALL, or reselect the folder.`,
			},
			"/UNSEEN": {
				Description: `  Lists messages that have not been  seen (seen message are indicated by
  a greater  than sign).  Using /UNSEEN is  equivalent to  selecting the
  folder with  /UNSEEN, i.e. only unseen  messages will be shown  and be
  able to be read. To see all messages, use either /ALL, or reselect the
  folder.`,
			},
			"/NEW": {
				Description: `  Specifies  to start  the listing  of  messages with  the first  unread
  message.`,
			},
			"/PRINT": {
				Description: `  Specifies  that the  text  of  the messages  which  are  found by  the
  DIRECTORY command  are to be  printed. All qualifiers which  are valid
  for the PRINT  command are valid in conjunction with  /PRINT. The list
  of  messages to  be  printed will  be displayed  on  the terminal  (in
  nopaging format).`,
			},
			"/REPLY": {
				Description: `  Specifies that only messages which  are replies to the current message
  are  to  be  displayed.  This  cannot  be  used  in  conjunction  with
  /MARKED.`,
			},
			"/SEARCH": {
				Description: `/SEARCH=[string]

  Specifies that only messages which contain the specified string are to
  be displayed. This  cannot be used in conjunction with  /MARKED. If no
  string is specified, the previously specified string is used.`,
				OptArg: true,
			},
			"/SINCE": {
				Description: `/SINCE=date

  Displays  a listing  of  all  the messages  created  on  or after  the
  specified date. If no date is specified, the default is TODAY.`,
				OptArg: true,
			},
			"/START": {
				Description: `/START=message_number

  Indicates the first  message number you want to  display. For example,
  to display  all the  messages beginning with  number three,  enter the
  command line DIRECTORY/START=3. Not valid with /FOLDER.`,
				OptArg: true,
			},
			"/SUBJECT": {
				Description: `/SUBJECT=[string]

  Specifies that  only messages  which contain  the specified  string in
  it's  subject header  are  to be  displayed. This  cannot  be used  in
  conjunction with  /MARKED. If no  string is specified,  the previously
  specified string is used.`,
				OptArg: true,
			},
		},
	},
	"EXIT": {
		Description: `Exits the BULLETIN program.`,
		Action:      ActionExit,
	},
	"EXTRACT": {
		Description: `Synonym for FILE command.`,
	},
	"FILE": {
		Description: `Copies the current message to the named file. The file-name parameter is
required.  If the  file exists,  the message  is appended  to the  file,
unless the /NEW qualifier is specified.

  Format:
    FILE filename [message_number][-message_number1],[...]

A range of messages to be  copied can optionally be specified, i.e FILE.
2-5                                                                    .

The key words  CURRENT and LAST can  also be specified in  the range in,
place of an actual number, i.e. CURRENT-LAST, 1-CURRENT, etc.`,
		MinArgs: 1,
		MaxArgs: 2,
		Flags: dclish.Flags{
			"/ALL": {
				Description: `  Copies all the messages in the current folder.`,
			},
			"/FF": {
				Description: `  Specifies that a form feed is placed between messages in the file.`,
			},
			"/HEADER": {
				Description: `/[NO]HEADER

  Controls whether a  header containing the owner, subject,  and date of
  the  message is  written in  the  file. The  default is  to write  the
  header.`,
			},
			"/NEW": {
				Description: `  Specifies  that  a new  file  is  to  be  created. Otherwise,  if  the
  specified file exists, the file would be appended to that file.`,
			},
		},
	},
	"FIRST": {
		Description: `Specifies that the first message in the folder is to be read.`,
		Action:      ActionFirst,
	},
	"FORWARD": {
		Description: `Synonym for MAIL command.`,
		Action:      ActionForward,
	},
	"HELP": {
		Description: `To obtain help on any topic, type:

        HELP  topic`,
		MaxArgs: 1,
		Action:  ActionHelp,
	},
	"INDEX": {
		Description: `Gives directory  listing of  all folders in  alphabetical order.  If the
INDEX  command is  re-entered  while  the listing  is  in progress,  the
listing will  skip to  the next  folder. This is  useful for  skipping a
particular folder.  It also  can be  used to  continue the  listing from
where one left off after one has read a message.

  Format:
    INDEX`,
		Action: ActionIndex,
		Flags: dclish.Flags{
			"/MARKED": {
				Description: `  Lists messages that have been marked (marked messages are indicated by
  an asterisk). This is equivalent to selecting the folder with /MARKED,
  i.e. only marked messages will be shown and be able to be read.`,
			},
			"/UNMARKED": {
				Description: `  Lists  messages  that  have  not  been  marked  (marked  messages  are
  indicated by an asterisk). Using  /UNMARKED is equivalent to selecting
  the folder with  /UNMARKED, i.e. only unmarked messages  will be shown
  and be able to be read.`,
			},
			"/SEEN": {
				Description: `  Lists messages that have been seen (indicated by a greater than sign).
  Using /SEEN  is equivalent  to selecting the  folder with  /SEEN, i.e.
  only seen messages will be shown and be able to be read.`,
			},
			"/UNSEEN": {
				Description: `  Lists messages that have not been seen (seen message are indicated by a
  greater than sign). Using /UNSEEN is equivalent to selecting the folder
  with /UNSEEN, i.e. only unseen messages will be shown and be able to be
  read.`,
			},
			"/NEW": {
				Description: `  Specifies to  start the listing of  each folder with the  first unread
  message. Otherwise, the  listing will start with the  first message in
  the  folder. If  the INDEX  command is  re-entered for  continuing the
  listing, /NEW must be respecified.`,
			},
			"/RESTART": {
				Description: `  If specified,  causes the listing  to be reinitialized and  start from
  the first folder.`,
			},
			"/SUBSCRIBE": {
				Description: `  If  specified,  lists  only  those   news  folders  which  have  been
  subscribed to.`,
			},
		},
	},
	"LAST": {
		Description: `Displays the last message in the current folder.

  Format:
    LAST`,
		Flags: dclish.Flags{
			"/EDIT": {
				Description: `  Specifies that the editor  is to be used to read  the message. This is
  useful for scanning a long message.`,
			},
			"/HEADER": {
				Description: `/[NO]HEADER

  Specifies that if  a message header exists, the header  will be shown.
  If /HEADER or  /NOHEADER is specified, the setting will  apply for all
  further reads in the selected folder. The default is /HEADER.`,
			},
		},
	},
	"MAIL": {
		Description: `Invokes the  VAX/VMS Personal  Mail Utility (MAIL)  to send  the message
which you are reading to the specified recipients.

  Format:
    MAIL recipient-name[s]

The input for the  recipient name is exactly the same  format as used by
the MAIL command  at DCL level. Note that this  means when specifying an
address that  has quotes, in order  to pass the quotes  you must specify
triple quotes. I.e. a network address  of the form xxx%"address" must be
specified as xxx%"""address""".`,
		MinArgs: 1,
		MaxArgs: 10,
		Flags: dclish.Flags{
			"/EDIT": {
				Description: `  Specifies that  the editor is  to be used  to edit the  message before
  mailing it.`,
			},
			"/HEADER": {
				Description: `/[NO]HEADER

  Controls whether a  header containing the owner, subject,  and date of
  the  message is  written in  the  mail. The  default is  to write  the
  header.`,
			},
			"/SUBJECT": {
				Description: `/SUBJECT=text

  Specifies the subject of the mail message. If the text consists of more
  than one word, enclose the text in quotation marks (").

  If you omit this qualifier, the description of the message will be used
  as the subject.`,
				OptArg: true,
			},
		},
	},
	"MARK": {
		Description: `Sets the  current or message-id  message as marked. Marked  messages are
displayed with  an asterisk  in the  left hand  column of  the directory
listing.  A  marked  message  can  serve  as  a  reminder  of  important
information.

  Format:
    MARK [message-number or numbers]`,
		MaxArgs: 1,
	},
	"UNMARK": {
		Description: `Sets the current  or message-id message as unmarked.

  Format:
    UNMARK [message-number or numbers]`,
		MaxArgs: 1,
	},
	"MODIFY": {
		Description: `Modifies the database information for the current folder. Only the owner
of the folder or a user with privileges can use this command.

  Format:
    MODIFY`,
		Action: ActionModify,
		Flags: dclish.Flags{
			"/DESCRIPTION": {
				Description: `  Specifies a new  description for the folder. You will  be prompted for
  the text of the description.`,
			},
			"/ID": {
				Description: `  Designates  that the  name specified  as the  owner name  is a  rights
  identifier. The  creator's process must have  the identifier presently
  assigned to it.  Any process which has that identifier  assigned to it
  will be able to  control the folder as if it  were the folder's owner.
  This is used to allow more than one use to control a folder.

  Note: This feature will not work during remote access to the folder.`,
			},
			"/NAME": {
				Description: `/NAME=foldername

  Specifies a new name for the folder.`,
				OptArg: true,
			},
			"/OWNER": {
				Description: `/OWNER=username

  Specifies  a new  owner for  the folder.  If the  owner does  not have
  privileges, BULLETIN  will prompt  for the password  of the  new owner
  account in order to okay the modification. See also /ID.`,
				OptArg: true,
			},
		},
	},
	"MOVE": {
		Description: `Moves a message to another  folder and deletes it from  the  current
folder.

  Format:
    MOVE folder-name [message_number][-message_number1]

The folder-name is the name of the  folder to which the message is to be
be moved to. Optionally,  a range of messages which are  to be moved can
be  specified  following  the  folder name,  i.e.  COPY  NEWFOLDER  2-5.
However,  if the  old folder  is  remote, they  will be  copied but  not
deleted, as  only one message  can be delted from  a remote folder  at a
time.

The key words  CURRENT and LAST can  also be specified in  the range in,
place of an actual number, i.e. CURRENT-LAST, 1-CURRENT, etc.`,
		MinArgs: 1,
		MaxArgs: 2,
		Flags: dclish.Flags{
			"/ALL": {
				Description: `  Specifies to move  all the messages from the old  folder. Note: If the
  old folder is remote, they will be copied but not deleted, as only one
  message can be deleted from a remote folder at a time.`,
			},
			"/MERGE": {
				Description: `  Specifies that  the original date and  time of the moved  messages are
  saved and that the messages  are placed in correct chronological order
  in the  new folder.  This operation  is lengthy if  the new  folder is
  large.`,
			},
			"/ORIGINAL": {
				Description: `  Specifies that  the owner of  the moved  message will be  the original
  owner of  the message. The default  is that the moved  message will be
  owned by the person moving the message.`,
			},
		},
	},
	"NEXT": {
		Description: `Skips to  the next message and  displays it. This is  useful when paging
through the messages and you  encounter a particularly long message that
you would like to skip over.`,
		Action: ActionNext,
		Flags: dclish.Flags{
			"/EDIT": {
				Description: `  Specifies that the editor  is to be used to read  the message. This is
  useful for scanning a long message.`,
			},
			"/HEADER": {
				Description: `/[NO]HEADER

  Specifies that if  a message header exists, the header  will be shown.
  If /HEADER or  /NOHEADER is specified, the setting will  apply for all
  further reads in the selected folder. The default is /HEADER.`,
			},
		},
	},
	"PRINT": {
		Description: `Queues a  copy of the  message you are  currently reading (or  have just
read)  for printing.  The  file  created by  the  PRINT  command is  not
released to the print queue until you exit, unless you add the qualifier
/NOW or change one of the  print job's qualifiers. Multiple messages are
concatenated into one print job.

  Format:
    PRINT [message_number][-message_number1],[...]

A range  of messages  to be  printed can  optionally be  specified, i.e.
PRINT 2-5.

The key words  CURRENT and LAST can  also be specified in  the range, in
place of an actual number, i.e. CURRENT-LAST, 1-CURRENT, etc.

NOTE: The  qualifier /PRINT  is present on  the DIRECTORY  command. This
provides more  flexibility than is  present with the PRINT  command. For
example, if you  want to print all messages with  a particular string in
it's subject line, DIRECTORY/PRINT/SUBJ would allow you do it.`,
		MaxArgs: 1,
		Flags: dclish.Flags{
			"/ALL": {
				Description: `  Prints all the messages in the current folder.`,
			},
			"/FORM": {
				Description: `  Specifies the name or  number of the form that you  want for the print
  job. Codes  for form types  are installation-defined. You can  use the
  SHOW  QUEUE/FORM command  at  DCL level  to find  out  the form  types
  available  for your  system. Use  the SHOW  QUEUE/FULL command  at DCL
  level to find  out the name of  the mounted form and  the default form
  for a particular queue. If you specify a form whose stock is different
  from the stock of the form mounted on the queue, your job is placed in
  a pending state  until the stock of  the mounted form of  the queue is
  set equal to the stock of the  form associated with the job. (In order
  to have  your job  print, the  system manager  should stop  the queue,
  physically change  the paper stock  on the output device,  and restart
  the queue specifying the new form type as the mounted form.)`,
			},
			"/HEADER": {
				Description: `/[NO]HEADER

  Controls whether a header containing the owner, subject, and date of the
  message is printed at the beginning. The default is to write the header.`,
			},
			"/NOTIFY": {
				Description: `/[NO]NOTIFY

  Indicates that  you will be notified  by a broadcast message  when the
  file or files  have been printed. If /NONOTIFY is  specified, there is
  no notification. The default is /NOTIFY.`,
				Default: "true",
			},
			"/NOW": {
				Description: `  Sends all messages  that have been queued for printing  with the PRINT
  command during this session to the printer.`,
			},
			"/QUEUE": {
				Description: `/QUEUE=queue_name

  The name of the queue to which a  message is to be sent. If the /QUEUE
  qualifier is not specified, the message is queued to SYS$PRINT.`,
				OptArg: true,
			},
		},
	},
	"READ": {
		Description: `Displays the  specified message. If you  do not specify a  message, then
the first  time you enter the  command, the first message  in the folder
will be  displayed. However, if  there are  new messages, the  first new
message will  be displayed. Each  time you  enter the command,  the next
page, or if there are no more pages, the next message will be displayed.

  Format:
    READ [message-number]

The message's relative number is found  by the DIRECTORY command. If you
specify a number greater than the  number of messages in the folder, the
last message in the folder will be displayed.

NOTE: The READ command can be  abbreviated by omitting the READ command,
i.e.  typing the  command  "2" is  equivalent to  "READ  2", and  simply
hitting the <RETURN> key is equivalent to "READ".

BULLETIN normally stores only the latest  message that has been read per
folder. It  can optionally  store and display  which messages  have been
read in a  folder on a per  message basis. For information  on this, see
the help on the SEEN command.`,
		MaxArgs: 1,
		Action:  ActionRead,
		Flags: dclish.Flags{
			"/ALL": {
				Description: `  Specifies to read all messages.  Used after /MARKED, /UNMARKED, /SEEN,
  or /UNSEEN had been specified.`,
			},
			"/EDIT": {
				Description: `  Specifies that the editor  is to be used to read  the message. This is
  useful for scanning a long message.`,
			},
			"/HEADER": {
				Description: `/[NO]HEADER

  Specifies that if  a message header exists, the header  will be shown.
  If /HEADER or  /NOHEADER is specified, the setting will  apply for all
  further reads in the selected folder. The default is /HEADER.`,
			},
			"/MARKED": {
				Description: `  Specifies to read only messages that have been marked (marked messages
  are  indicated  by  an  asterisk).  Using  /MARKED  is  equivalent  to
  selecting the folder  with /MARKED, i.e. only marked  messages will be
  shown and be able to be read. To see all messages, use either /ALL, or
  reselect the folder.`,
			},
			"/UNMARKED": {
				Description: `  Specifies  to read  only messages  that have  not been  marked (marked
  messages are indicated by an  asterisk). Using /UNMARKED is equivalent
  to selecting  the folder with  /UNMARKED, i.e. only  unmarked messages
  will be  shown and  be able to  be read. To  see all  messages, either
  reselect the folder or specify /ALL.`,
			},
			"/SEEN": {
				Description: `  Specifies to  read only messages that  have been seen (indicated  by a
  greater than sign). Using /SEEN  is equivalent to selecting the folder
  with /SEEN, i.e.  only seen messages will  be shown and be  able to be
  read. To see all messages, use either /ALL, or reselect the folder.`,
			},
			"/UNSEEN": {
				Description: `  Specifies to read only messages that  have not been seen (seen message
  are indicated by a greater than  sign). Using /UNSEEN is equivalent to
  selecting the folder  with /UNSEEN, i.e. only unseen  messages will be
  shown and be able to be read. To see all messages, use either /ALL, or
  reselect the folder.`,
			},
			"/NEW": {
				Description: `  Specifies to read the first unread message.`,
			},
			"/PAGE": {
				Description: `/[NO]PAGE

  Specifies that the  display of the message will pause  when it reaches
  the end of  the page. If /NOPAGE is specified,  the whole message will
  be displayed.  This is useful for  terminals that can store  more than
  one screenful at a time, and that  have a remote printer that can then
  print the contents of the terminal's memory.`,
			},
			"/SINCE": {
				Description: `/SINCE=date

  Specifies to read the first message  created on or after the specified
  date. If no date is specified, the default is TODAY.`,
				OptArg: true,
			},
		},
	},
	"REMOVE": {
		Description: `Removes a folder.  Only the owner of  a folder or a  privileged user can
remove the folder.

  Format:
    REMOVE folder-name`,
		MinArgs: 1,
		MaxArgs: 1,
		Action:  ActionRemove,
	},
	"REPLY": {
		Description: `Adds message with subject of message being the subject of the  currently
read message with "RE:" preceeding it.  Format and qualifiers is exactly
the same as the ADD command except for /NOINDENT and /EXTRACT.

  Format:
    REPLY [file-name]`,
		MaxArgs: 1,
		Action:  ActionReply,
		Flags: dclish.Flags{
			"/EDIT": {
				Description: `  Specifies  that the  editor  is  to be  used  for  creating the  reply
  message.`,
			},
			"/EXTRACT": {
				Description: `  Specifies that the text of the message should be included in the reply
  message. This qualifier  is valid only when used with  /EDIT. The text
  of the message is indented with >  at the beginning of each line. This
  can be suppressed with /NOINDENT.`,
			},
			"/INDENT": {
				Description: `  See /EXTRACT for information on this qualifier.

  Defaults to set - use /NOINDENT to suppress.`,
				Default: "true",
			},
		},
	},
	"RESPOND": {
		Description: `Invokes the  VAX/VMS Personal Mail Utility  (MAIL) to send a  reply mail
message to the owner of the currently read message.

  Format:
    RESPOND [file-name]

If  you  wish  to  use  another method  for  sending  the  mail,  define
BULL_MAILER to point to a command procedure. This procedure will then be
executed  in place  of MAIL,  and the  parameters passed  to it  are the
username and subject of the message.`,
		MaxArgs: 1,
		Flags: dclish.Flags{
			"/CC": {
				Description: `/CC=user[s]
  Specifies additional users that should receive the reply.`,
				OptArg: true,
			},
			"/EDIT": {
				Description: `  Specifies that  the editor is to  be used for creating  the reply mail
  message.`,
			},
			"/EXTRACT": {
				Description: `  Specifies that the text of the message should be included in the reply
  mail message. This  qualifier is valid only when used  with /EDIT. The
  text of the message is indented with  > at the beginning of each line.
  This can be suppressed with /NOINDENT.`,
			},
			"/LIST": {
				Description: `  Specifies that  the reply should also  be sent to the  network mailing
  list  associated with  the  folder. The  mailing  list address  should
  be  stored  in  the  folder  description.  See  CREATE/DESCRIPTION  or
  MODIFY/DESCRIPTION for more informaton.`,
			},
			"/INDENT": {
				Description: `  See /EXTRACT for information on this qualifier.

  Defaults to set - use /NOINDENT to suppress.`,
				Default: "true",
			},
			"/SIGNATURE": {
				Description: `  Specifies  to   automatically  appended  signature,  if   one  exists.
  Signatures are appended for postings to mailing lists and to responds.
  See the help topic POST Signature_file for signature information     .

  Defaults to set - use /NOSIGNATURE to suppress.`,
				Default: "true",
			},
			"/SUBJECT": {
				Description: `/SUBJECT=text

  Specifies the  subject of the  mail message.  If the text  consists of
  more than one word, enclose the text in quotation marks (").

  If you  omit this qualifier,  the description  of the message  will be
  used as the subject preceeded by "RE: ".`,
				OptArg: true,
			},
		},
	},
	"QUIT": {
		Description: `Exits the BULLETIN program.`,
		Action:      ActionQuit,
	},
	"SEARCH": {
		Description: `Searches the  currently selected folder  for the message  containing the
first occurrence of the specified text string.

  Format:
    SEARCH [search-string]

The search  starts from  the first  message in  the current  folder. The
search  includes both  the  text  of the  message,  and the  description
header. If  a "search-string" is not  specified, a search is  made using
the previously specified string, starting with the message following the
one  you are  currently reading  (or have  just read).  Once started,  a
search can be aborted by typing a CTRL-C.`,
		MinArgs: 1,
		MaxArgs: 1,
		Flags: dclish.Flags{
			"/EDIT": {
				Description: `  Specifies that the editor is to be used for reading the message.`,
			},
			"/FOLDER": {
				Description: `/FOLDER=(folder,[...])

  Specifies a list of folders to be searched.  The search will start by
  selecting the first folder in the list and searching the messages for
  a match.  If, during a search, no more matches or messages are found,
  the next folder in the list is automatically selected.  The presently
  selected folder can be included in the search by specifying "" as the
  first folder in the list.`,
				OptArg: true,
			},
			"/REPLY": {
				Description: `  Specifies that messages are to be searched for that are replies to the
  currently read  message, or the  message specified by  /START. Replies
  are messages  which have subject  of the original message  prefaced by
  "Re:".`,
			},
			"/REVERSE": {
				Description: `  Specifies that the messages are to be searched in reverse order. If no
  starting message  is specified,  the search is  started from  the last
  message.`,
			},
			"/START": {
				Description: `/START=message_number

  Specifies the message number to start the search at.`,
				OptArg: true,
			},
			"/SUBJECT": {
				Description: `  Specifies that only the subject of the messages are to be searched.`,
			},
		},
	},
	"SEEN": {
		Description: `Sets the current or message-id message  as seen. This allows you to keep
track of  messages on a per  message basis. Seen messages  are displayed
with  a greater  than sign  in  the left  hand column  of the  directory
listing. Once  you have  used the  SEEN command  once, messages  will be
automatically  be set  as  being SEEN  when they  are  read.

  Format:
    SEEN [message-number or numbers]

If you  have used  the SEEN  command and wish  to disable  the automatic
marking of messages in regular folders  as SEEN when they are read, type
the command SEEN/NOREAD. To reenable, simply use the SEEN command again.`,
		MaxArgs: 1,
		Action:  ActionSeen,
	},
	"UNSEEN": {
		Description: `Sets the current or message-id message as unseen.

  Format:
    UNSEEN [message-number or numbers]`,
		MaxArgs: 1,
		Action:  ActionUnseen,
	},
	"SELECT": {
		Description: `Selects a folder of messages.  See HELP Folders for a description  of  a
folder.   Once a folder has been selected, all commands, i.e. DIRECTORY,
READ, etc. will apply only to those messages.  Use the CREATE command to
create  a  folder.   Use the DIRECTORY/FOLDER command to see the list of
folders that have been created.

  Format:
    SELECT [folder-name]

The complete folder name need not be specified.  BULLETIN  will  try  to
find the closest matching name.  I.e. INFOV can be used for INFOVAX.

Omitting the folder name will select the default general messages.

After selecting a folder, the user will notified of the number of unread
messages,  and  the  message  pointer will be placed at the first unread
message.`,
		Action:  ActionSelect,
		MinArgs: 1,
		MaxArgs: 1,
		Flags: dclish.Flags{
			"/MARKED": {
				Description: `  Selects  only messages that have been marked (indicated by an asterisk).
  After using /MARKED, in order to see all messages, the folder will  have
  to be reselected.`,
			},
		},
	},
	"SET": {
		Description: `The SET command  is  used  with  other  commands  to  define  or  change
characteristics of the BULLETIN Utility.

  Format:
    SET option`,
		Commands: dclish.Commands{
			"ACCESS": {
				Description: `Controls  access  to  a  private  folder.   A private folder can only be
selected by users who have been granted access.  Only the owner of  that
folder is allowed to grant access.

  Format:
    SET [NO]ACCESS id-name [folder-name]

The id-name can be one or more ids from the system Rights  Database  for
which  access  is  being  modified.   It  can  also be a file name which
contains a list of  ids.   For  more  information  concerning  usage  of
private  folders, see HELP CREATE /PRIVATE.  NOTE: Access is created via
ACLs.  If a user's process privileges are set  to  override  ACLs,  that
user  will  be  able  to  access  the folder even if access has not been
granted.

It  is suggested that if you plan on granting access to many users, that
you create an id using the AUTHORIZE utility and then use the SET ACCESS
command  to  grant  access  to  that id.  Then, you can use the GRANT/ID
command in AUTHORIZE to grant the id to users, and this will give  those
users  access to the folder.  This is preferred because of problems with
running into system quota when checking for acls on a file with a  large
amount  of  acls.   It  is also means that you don't have to remember to
remove the access for that user from a folder if that  user  is  removed
from the system.

A user with BULLETIN privileges (see HELP SET  PRIV)  will  be  able  to
select a protected folder regardless of the access settings.  However, a
user without explicit access will not receive login notifications of new
messages,  and thus will not be able to set any login flags.  (NOTE:  If
such a user selects such a folder and then uses SET ACCESS to grant  him
or  herself  access,  the user must reselect the folder in order for the
new access to take affect in order to be able to set login flags.)

The id-name can be one or  more  ids  contained  in  the  system  Rights
Database.   This  includes  usernames  and  UICs.  A UIC that contains a
comma must be enclosed in quotes.   UICs  can  contain  wildcards,  i.e.
"[130,*]".   Note that by default, a process is given the process rights
id SYS$NODE_nodename, where nodename is the decnet nodename.   Thus,  by
specifing  this id, a folder can be restricted to a specific node, which
is useful when the folder is shared among nodes in a cluster.

Alternatively,  the  id-name  can be a filename which contains a list of
ids.  The filename should be preceeded by a "@".  If the suffix  is  not
specified, it will be assumed that the suffix is ".DIS" .

Warning

  If  a  user  logs  in after a private folder has been created but before
  being given access, and then is given  access,  any  defaults  that  the
  folder  has,  i.e. /BRIEF, /READNEW, & /NOTIFY, will not be set for that
  user. This is because if the  id  is  not  a  username,  it  becomes  an
  extremely  lengthy  operation  to check each user to see if have that id
  assigned to them.  The alternative is to set the defaults for all  users
  after  every  SET  ACCESS,  but that might cause problems with users who
  have manually reset those defaults.  The  correct  solution  requires  a
  large programming modification, which will be done in a later version.`,
				MinArgs: 1,
				MaxArgs: 1,
				Flags: dclish.Flags{
					"/ALL": {
						Description: `  Specifies that access to the folder is granted to all users.   If  /READ
  is  not  specified,  the  folder will no longer be private.  If /READ is
  specified, all users will have read access, but  only  privileged  users
  will  have  write access (of course non-privileged users can gain access
  via a later SET ACCESS command.)

  Format:
    SET ACCESS /ALL[=folder-name]`,
						OptArg: true,
					},
					"/READ": {
						Description: `  Specifies that access to the folder will be limited to being able to
  read the messages.`,
					},
				},
			},
			"ALWAYS": {
				Description: `Specifies  that  the  selected  folder  has  the ALWAYS attribute.  This
causes messages in the folder to be displayed differently  when  logging
in.  SYSTEM messages will be displayed every time a user logs in, rather
than just once.  Non-SYSTEM message will also be  displayed  every  time
(in  whatever  mode  is selected, i.e. BRIEF, SHOWNEW, or READNEW) until
the user actually reads that message (or a later one).  This feature  is
meant  for  messages which are very important, and thus you want to make
sure they are read.

  Format:
    SET ALWAYS`,
			},
			"NOALWAYS": {
				Description: `Removes ALWAYS attribute from the selected folder.

  Format:
    SET NOALWAYS`,
			},
			"BRIEF": {
				Description: `Controls whether you will be alerted upon logging  that  there  are  new
messages  in the currently selected folder.  A new message is defined as
one that has been created since the last time you logged in or  accessed
BULLETIN.   Note  the  difference between BRIEF and READNEW.  The latter
causes a listing of the description of the new messages to be  displayed
and  prompts  the user to read the messages.  Setting BRIEF will clear a
READNEW setting (and visa versa).

  Format:
    SET BRIEF`,
				Flags: dclish.Flags{
					"/ALL": {
						Description: `  Specifies that the  SET BRIEF option is the default  for all users for
  the specified folder. This is a privileged qualifier.`,
					},
					"/DEFAULT": {
						Description: `  Specifies  that the  BRIEF option  is  the default  for the  specified
  folder. This is a privileged qualifier.  It will only affect brand new
  users (or  those that have  never logged in).  Use /ALL to  modify all
  users.`,
					},
					"/PERMANENT": {
						Description: `/[NO]PERMANENT

Specifies that BRIEF is a permanent flag and cannot be changed by the
individual, except if changing to SHOWNEW or READNEW.  This is a
privileged qualifier.`,
					},
				},
			},
			"NOBRIEF": {
				Description: `Turns off BRIEF for the selected or specified folder.

  Format:
    SET NOBRIEF`,
				Flags: dclish.Flags{
					"/ALL": {
						Description: `  Specifies that the SET NOBRIEF option is the default for all users for
  the specified folder. This is a privileged qualifier.`,
					},
					"/DEFAULT": {
						Description: `  Specifies that  the NOBRIEF  option is the  default for  the specified
  folder. This is a privileged qualifier.  It will only affect brand new
  users (or  those that have  never logged in).  Use /ALL to  modify all
  users.`,
					},
					"/FOLDER": {
						Description: `/FOLDER=foldername

  Specifies the folder for which the option is to modified.  If not
  specified, the selected folder is modified.`,
					},
				},
			},
			"DEFAULT_EXPIRE": {
				Description: `Specifies  the  number  of days the message created by BBOARD (or direct
PMDF path) is to be retained.  The default  is  14  days.   The  highest
limit  that  can  be  specified is 30 days.  This can be overridden by a
user with privileges.

This  also  specifies the default expiration date when adding a message.
If no expiration date is  entered  when  prompted  for  a  date,  or  if
prompting  has been disabled via SET NOPROMPT_EXPIRE, this value will be
used.

  Format:
    SET DEFAULT_EXPIRE days

If -1 is specified, messages will become permanent.  If 0 is  specified,
no  default expiration date will be present.  The latter should never be
specified for a  folder  with  a  BBOARD,  or  else  the  messages  will
disappear.

NOTE: This value is the same value that SET BBOARD/EXPIRATION specifies.
If one is changed, the other will change also.`,
				MinArgs: 1,
				MaxArgs: 1,
			},
			"EXPIRE_LIMIT": {
				Description: `Specifies expiration limit that  is allowed for messages. Non-privileged
users  cannot specify  an expiration  that  exceeds the  number of  days
specified.  Privileged users  can exceed  the limit.  Setting days  to 0
removes the expiration limit.

  Format:
    SET EXPIRE_LIMIT days

The command SHOW FOLDER/FULL will show  the  expiration  limit,  if  one
exists.  (NOTE: SHOW FOLDER/FULL is a privileged command.)`,
				MinArgs: 1,
				MaxArgs: 1,
			},
			"FOLDER": {
				Description: `Select a folder of messages.  Identical to the SELECT command.  See help
on that command for more information.

  Format:
    SET FOLDER [folder-name]`,
				MaxArgs: 1,
				Action:  ActionSetFolder,
				Flags: dclish.Flags{
					"/MARKED": {
						Description: `  Selects messages that have been marked (indicated by an asterisk). After
  using /MARKED, in order to see all  messages, the folder will have to be
  reselected.`,
					},
				},
			},
			"NOTIFY": {
				Description: `Specifies whether you will be notified via a broadcast  message  when  a
message is added to the selected folder.

  Format:
    SET NOTIFY

In a cluster, if the logical name MAIL$SYSTEM_FLAGS is defined so that
bit 1 is set, users will be notified no matter which node they are logged
in to.  If you wish to disable this, you should define BULL_SYSTEM_FLAGS
so that bit 1 is cleared.`,
				Flags: dclish.Flags{
					"/ALL": {
						Description: `  Specifies that the SET NOTIFY option  is the default for all users for
  the specified folder. This is a privileged qualifier.`,
					},
					"/DEFAULT": {
						Description: `  Specifies  that the  NOTIFY option  is the  default for  the specified
  folder. This is a privileged qualifier.  It will only affect brand new
  users (or  those that have  never logged in).  Use /ALL to  modify all
  users.`,
					},
					"/PERMANENT": {
						Description: `/[NO]PERMANENT

  Specifies that  NOTIFY is a  permanent flag  and cannot be  changed by
  the  individual. /DEFAULT  must  be specified.  This  is a  privileged
  qualifier.`,
					},
				},
			},
			"NONOTIFY": {
				Description: `Removes notification from the current folder or optional folder-name.

  Format:
    SET NONOTIFY [folder-name]`,
				MaxArgs: 1,
			},
			"PRIVILEGES": {
				Description: `Specifies  either  process  privileges  or  rights  identifiers that are
necessary to use privileged commands.  Use the SHOW  PRIVILEGES  command
to see what is presently set.  This is a privileged command.

  Format:
    SET PRIVILEGES parameters

The parameters are one or  more  privileges  separated  by  commas.   To
remove  a privilege, specify the privilege preceeded by "NO".  If /ID is
specified, the parameters are rights identifiers.

For the reimplementation this is used to manage users.  The following parameters
are available.

  Format:
	  SET PRIVILEGES CREATE login
	  SET PRIVILEGES DELETE login
	  SET PRIVILEGES SSH [login]
	  SET PRIVILEGES [NO]ADMIN login
	  SET PRIVILEGES [NO]MOD login [folder]
	  SET PRIVILEGES ENABLE login
	  SET PRIVILEGES DISABLE login`,
				MinArgs: 1,
				MaxArgs: 3,
				Action:  ActionSetPrivileges,
			},
			"PROMPT_EXPIRE": {
				Description: `Specifies  that a  user will  be prompted  for an  expiration date  when
adding a message. If the value  specified is greater than the expiration
limit, and the user does not  have privileges, then the expiration limit
will  be used  as the  default expiration.  (If there  is no  expiration
limit, and the user doesn't have privileges, then an error will result.)
PROMPT_EXPIRE is the default.

  Format:
    SET PROMPT_EXPIRE`,
			},
			"NOPROMPT_EXPIRE": {
				Description: `The user will not be prompted,  and the default expiration (which is set
by SET DEFAULT_EXPIRE) will be used.

  Format:
    SET NOPROMPT_EXPIRE`,
			},
			"READNEW": {
				Description: `Controls whether you will be prompted upon logging in  if  you  wish  to
read new non-system or folder messages (if any exist).  A new message is
defined as one that has been  added  since  the  last  login,  or  since
accessing BULLETIN.  The default setting for READNEW is dependent on how
the folder was created by the owner.

In  order  to  apply  this to a specific folder, first select the folder
(using the SELECT command), and then enter the SET READNEW command.

  Format:
    SET READNEW

NOTE:  If  you  have several folders with READNEW enabled, each folder's
messages will be displayed separately.  However, if you EXIT the READNEW
mode before all the folders have been displayed, you will not be alerted
of the new messages in the undisplayed folders the next time you  login.
However,  if  you enter BULLETIN, you will be told that new messages are
present in those other folders.  Also, it is not possible  to  EXIT  the
READNEW mode if there are SYSTEM folders which have new messages. Typing
the EXIT command will cause you to skip to those folders.  (See HELP SET
SYSTEM for a description of a SYSTEM folder).`,
				Flags: dclish.Flags{
					"/ALL": {
						Description: `  Specifies that the SET READNEW option is the default for all users for
  the specified folder.  This is a privileged  qualifier.`,
					},
					"/PERMANENT": {
						Description: `/[NO]PERMANENT

  Specifies that  READNEW is a permanent  flag and cannot be  changed by
  the individual. This is a privileged qualifier.`,
					},
				},
			},
			"NOREADNEW": {
				Description: `Turns off READNEW.
  Format:
    SET NOREADNEW`,
				Flags: dclish.Flags{
					"/ALL": {
						Description: `  Specifies that the  SET NOREADNEW option is the default  for all users
  for  the  specified  folder.  This  is  a  privileged  qualifier.`,
					},
					"/FOLDER": {
						Description: `/FOLDER=foldername

  Specifies  the folder  for which  the option  is to  modified. If  not
  specified, the selected folder is modified.`,
					},
				},
			},
			"SHOWNEW": {
				Description: `Controls whether a directory listing of new  messages  for  the  current
folder  will  be displayed when logging in.  This is similar to READNEW,
except you will not be prompted to read the messages.   The  default  is
dependent  on how the folder was created by the owner.  A new message is
defined as one that has been  added  since  the  last  login,  or  since
accessing BULLETIN.

In order to apply this to a specific folder,  first  select  the  folder
(using  the  SELECT  command),  and  then enter the SET SHOWNEW command.

  Format:
    SET SHOWNEW`,
				Flags: dclish.Flags{
					"/ALL": {
						Description: `  Specifies that the SET SHOWNEW option is the default for all users for
  the specified folder.  This is a privileged  qualifier.`,
					},
					"/PERMANENT": {
						Description: `/[NO]PERMANENT

  Specifies that  SHOWNEW is a permanent  flag and cannot be  changed by
  the individual,  except if changing  to READNEW. This is  a privileged
  qualifier.`,
					},
				},
			},
			"NOSHOWNEW": {
				Description: `Turns off SHOWNEW

  Format:
    SET NOSHOWNEW`,
				Flags: dclish.Flags{
					"/ALL": {
						Description: `  Specifies that the  SET NOSHOWNEW option is the default  for all users
  for  the  specified  folder.  This  is  a  privileged  qualifier.`,
					},
					"/FOLDER": {
						Description: `/FOLDER=foldername

  Specifies  the folder  for which  the option  is to  modified. If  not
  specified, the selected folder is modified.`,
					},
				},
			},
			"SYSTEM": {
				Description: `Specifies that the selected folder is a SYSTEM folder.  A SYSTEM folder
is allowed to have SYSTEM and SHUTDOWN messages added to it.  This is a
privileged command.

  Format:
    SET [NO]SYSTEM

By default, the GENERAL folder is a SYSTEM folder, and the setting for
that folder cannot be removed.

If the selected folder is remote, /SYSTEM cannot be specified unless the
folder at the other node is also a SYSTEM folder.
`,
			},
		},
	},
	"SHOW": {
		Description: `The SHOW command displays information about certain characteristics.
`,
		Commands: dclish.Commands{
			"FLAGS": {
				Description: `Shows whether BRIEF, NOTIFY, READNEW, or SHOWNEW has been set for the
currently selected folder.
`,
			},
			"FOLDER": {
				Description: `Shows information about a folder  of messages. Owner and description are
shown. If the folder name is omitted, and a folder has been selected via
the SELECT command, information about that folder is shown.

  Format:
    SHOW FOLDER [folder-name]`,
				MaxArgs: 1,
				Flags: dclish.Flags{
					"/FULL": {
						Description: `  Control  whether all  information  of the  folder  is displayed.  This
  includes the SYSTEM setting, the access list if the folder is private,
  and BBOARD information. This information is only those who have access
  to that folder.`,
					},
				},
			},
			"NEW": {
				Description: `Shows folders which have new unread  messages for which BRIEF or READNEW
have been set.`,
			},
			"PRIVILEGES": {
				Description: `Shows the  privileges necessary to  use privileged commands.  Also shows
any  rights identifiers  that would  also give  a user  privileges. (The
latter are ACLs which are set on the BULLUSER.DAT file.)`,
			},
			"USER": {
				Description: `Shows the last time that a user logged in, or if /FOLDER  is  specified,
the  latest  message which a user has read in the folder.  If NOLOGIN is
set for  a  user,  this  information  will  be  displayed.   This  is  a
privileged  command.   Non-privileged users will only be able to display
the information for their own account.

  Format:
    SHOW USER [username]

The username is optional.  If omitted, the process's username  is  used.
The  username should not be included if /ALL or /[NO]LOGIN is specified.

NOTE: The last logged in time displayed is that which is stored when the
BULLETIN/LOGIN command is executed, not that  which  VMS  stores.   Some
sites  make  BULLETIN/LOGIN  an  optional  command for users to store in
their own LOGIN.COM, so this command can be used  to  show  which  users
have done this.`,
				MaxArgs: 1,
				Flags: dclish.Flags{
					"/ALL": {
						Description: `  Specifies that information for all users is to be displayed. This is a
  privileged command.`,
					},
					"/LOGIN": {
						Description: `/[NO]LOGIN

  Specifies that only  those users which do not have  NOLOGIN set are to
  be  displayed. If  negated,  only  those users  with  NOLOGIN set  are
  displayed. This is  a privileged command. The qualifier  /ALL need not
  be specified.`,
					},
					"/FOLDER": {
						Description: `/FOLDER=[foldername]

  Specifies to display  the latest message that was read  by the user(s)
  for the  specified foldername. A  newsgroup can be specified,  but the
  info can only be shown if the user has subscribed to the newsgroup. If
  the foldername is not specified, the selected folder will be used.`,
					},
					"/SINCE": {
						Description: `/SINCE=[date]

  Specifies to display  only those users whose latest  read message date
  is the  same date  or later  than the  specified date.  If no  date is
  specified, the  date of the  current message  is used. Only  valid for
  folders or with /LOGIN. Use /START for newsgroups.`,
					},
					"/START": {
						Description: `/START=[number]

  Specifies to display only those users whose latest read message number
  is equal  to or greather  than the specified  number. If no  number is
  specified, the  message number  of the current  message is  used. Only
  valid for newsgroups. Use /SINCE for folders and with /LOGIN.`,
					},
				},
			},
			"VERSION": {
				Description: `  Shows the  version of BULLETIN  and the  date that the  executable was
  linked.`,
				Action: ActionShowVersion,
			},
		},
	},
}
