// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.29.0
// source: messages.sql

package storage

import (
	"context"
	"time"
)

const createMessage = `-- name: CreateMessage :exec
INSERT INTO messages (
  id, folder, author, subject, message, permanent, shutdown, expiration
) VALUES (
  (SELECT COALESCE(MAX(id), 0) + 1 FROM messages AS m WHERE m.folder = ?1),
  ?2, ?1, ?3, ?4, ?5, ?6, ?7)
`

type CreateMessageParams struct {
	Author     string
	Folder     string
	Subject    string
	Message    string
	Permanent  int64
	Shutdown   int64
	Expiration time.Time
}

func (q *Queries) CreateMessage(ctx context.Context, arg CreateMessageParams) error {
	_, err := q.db.ExecContext(ctx, createMessage,
		arg.Author,
		arg.Folder,
		arg.Subject,
		arg.Message,
		arg.Permanent,
		arg.Shutdown,
		arg.Expiration,
	)
	return err
}

const deleteAllMessages = `-- name: DeleteAllMessages :exec
DELETE FROM messages WHERE folder = ?
`

func (q *Queries) DeleteAllMessages(ctx context.Context, folder string) error {
	_, err := q.db.ExecContext(ctx, deleteAllMessages, folder)
	return err
}

const nextMsgid = `-- name: NextMsgid :one
SELECT CAST(COALESCE(MIN(id), 0) AS INT) FROM messages AS m
  WHERE m.folder = ?1 AND m.id > ?2
  AND id NOT IN (SELECT id FROM seen AS s WHERE s.folder = ?1 AND s.login = ?3)
`

type NextMsgidParams struct {
	Folder string
	ID     int64
	Login  string
}

func (q *Queries) NextMsgid(ctx context.Context, arg NextMsgidParams) (int64, error) {
	row := q.db.QueryRowContext(ctx, nextMsgid, arg.Folder, arg.ID, arg.Login)
	var column_1 int64
	err := row.Scan(&column_1)
	return column_1, err
}

const nextMsgidIgnoringSeen = `-- name: NextMsgidIgnoringSeen :one
SELECT CAST(MIN(id) AS INT) FROM messages AS m
  WHERE m.folder = ?1 AND m.id > ?2
`

type NextMsgidIgnoringSeenParams struct {
	Folder string
	ID     int64
}

func (q *Queries) NextMsgidIgnoringSeen(ctx context.Context, arg NextMsgidIgnoringSeenParams) (int64, error) {
	row := q.db.QueryRowContext(ctx, nextMsgidIgnoringSeen, arg.Folder, arg.ID)
	var column_1 int64
	err := row.Scan(&column_1)
	return column_1, err
}

const prevMsgid = `-- name: PrevMsgid :one
SELECT CAST(COALESCE(MAX(id), 0) AS INT) FROM messages AS m
  WHERE m.folder = ?1 AND m.id < ?2
  AND id NOT IN (SELECT id FROM seen AS s WHERE s.folder = ?1 AND s.login = ?3)
`

type PrevMsgidParams struct {
	Folder string
	ID     int64
	Login  string
}

func (q *Queries) PrevMsgid(ctx context.Context, arg PrevMsgidParams) (int64, error) {
	row := q.db.QueryRowContext(ctx, prevMsgid, arg.Folder, arg.ID, arg.Login)
	var column_1 int64
	err := row.Scan(&column_1)
	return column_1, err
}

const prevMsgidIgnoringSeen = `-- name: PrevMsgidIgnoringSeen :one
SELECT CAST(MAX(id) AS INT) FROM messages AS m
  WHERE m.folder = ?1 AND m.id < ?2
`

type PrevMsgidIgnoringSeenParams struct {
	Folder string
	ID     int64
}

func (q *Queries) PrevMsgidIgnoringSeen(ctx context.Context, arg PrevMsgidIgnoringSeenParams) (int64, error) {
	row := q.db.QueryRowContext(ctx, prevMsgidIgnoringSeen, arg.Folder, arg.ID)
	var column_1 int64
	err := row.Scan(&column_1)
	return column_1, err
}

const readMessage = `-- name: ReadMessage :one
SELECT id, folder, author, subject, message, permanent, shutdown, expiration, create_at, update_at FROM messages WHERE folder = ? AND id = ?
`

type ReadMessageParams struct {
	Folder string
	ID     int64
}

func (q *Queries) ReadMessage(ctx context.Context, arg ReadMessageParams) (Message, error) {
	row := q.db.QueryRowContext(ctx, readMessage, arg.Folder, arg.ID)
	var i Message
	err := row.Scan(
		&i.ID,
		&i.Folder,
		&i.Author,
		&i.Subject,
		&i.Message,
		&i.Permanent,
		&i.Shutdown,
		&i.Expiration,
		&i.CreateAt,
		&i.UpdateAt,
	)
	return i, err
}

const setMessageSeen = `-- name: SetMessageSeen :exec
INSERT INTO seen (login, folder, msgid) VALUES (?, ?, ?)
`

type SetMessageSeenParams struct {
	Login  string
	Folder string
	Msgid  int64
}

func (q *Queries) SetMessageSeen(ctx context.Context, arg SetMessageSeenParams) error {
	_, err := q.db.ExecContext(ctx, setMessageSeen, arg.Login, arg.Folder, arg.Msgid)
	return err
}

const unsetMessageSeen = `-- name: UnsetMessageSeen :exec
DELETE FROM seen WHERE login = ? AND folder = ? AND msgid = ?
`

type UnsetMessageSeenParams struct {
	Login  string
	Folder string
	Msgid  int64
}

func (q *Queries) UnsetMessageSeen(ctx context.Context, arg UnsetMessageSeenParams) error {
	_, err := q.db.ExecContext(ctx, unsetMessageSeen, arg.Login, arg.Folder, arg.Msgid)
	return err
}
