// Package folders are all the routines and sql for managing folders.
package folders

import "errors"

// User is the user structure.
type User struct {
	Login    string `db:"login"`
	Name     string `db:"name"`
	Admin    int    `db:"admin"`
	Disabled int    `db:"disabled"`
}

// GetUser gets a user.
func (s *Store) GetUser(login string) (*User, error) {
	user := &User{}
	err := s.db.Get(user,
		"SELECT login, name, admin, disabled FROM users WHERE login = $1",
		login)
	return user, err
}

// AddUser gets a user.
func (s *Store) AddUser(user User) error {
	result, err := s.db.NamedExec(
		`INSERT INTO users (login, name, admin) VALUES (:login, :name, :admin)`,
		user)
	if err != nil {
		return err
	}
	rows, err := result.RowsAffected()
	if err != nil {
		return err
	}
	if rows != 1 {
		return errors.New("Failed to add user")
	}
	return nil
}

// IsUserAdmin checks if a user is an admin.
func (s *Store) IsUserAdmin(user string) bool {
	found := 0
	s.db.Get(&found, "SELECT admin FROM users WHERE login = $1", user)
	return found == 1
}
