// Package folders are all the routines and sql for managing folders.
package folders

import (
	"fmt"
	"strings"
	"time"
)

// CreateMessage creates a new folder.
func (s *Store) CreateMessage(author, subject, message, folder string, permanent, shutdown int, expiration *time.Time) error {
	if expiration == nil {
		var days int
		err := s.db.Get(&days, "SELECT expire FROM folders WHERE name = $1", folder)
		if err != nil {
			return err
		}
		if days <= 0 {
			days = 14
		}
		exp := time.Now().AddDate(0, 0, days)
		expiration = &exp
	}
	// TODO: replace _ with rows and check.
	_, err := s.db.Exec(
		`INSERT INTO messages
			(id, folder, author, subject, message, permanent, shutdown, expiration)
			VALUES
			((SELECT COALESCE(MAX(id), 0) + 1 FROM messages WHERE folder = $1), $1, $2, $3, $4, $5, $6, $7)`,
		folder,
		author,
		subject,
		message,
		permanent,
		shutdown,
		expiration, // TODO: handle this being NULL
	)
	// TODO: process this error a bit more to give a better error message.
	return err
}

// Message contains a message
type Message struct {
	ID       int       `db:"id"`
	Folder   string    `db:"folder"`
	Author   string    `db:"author"`
	Subject  string    `db:"subject"`
	Message  string    `db:"message"`
	Expires  time.Time `db:"expiration"`
	CreateAt time.Time `db:"create_at"`
	UpdateAt time.Time `db:"update_at"`
}

// String renders a message.
func (m *Message) String() string {
	buf := &strings.Builder{}
	// TODO: Show if an edit has happened.
	fmt.Fprintf(buf, "From: \"%s\" %s\n", m.Author, m.CreateAt.Format("02-JAN-2006 15:04:05"))
	fmt.Fprintf(buf, "To: %s\n", m.Folder)
	fmt.Fprintf(buf, "Subj: %s\n\n", m.Subject)
	fmt.Fprintf(buf, "%s\n", m.Message)

	return buf.String()
}

// ReadMessage reads a message for a user.
func (s *Store) ReadMessage(login, folder string, msgid int) (*Message, error) {
	msg := &Message{}
	err := s.db.Get(msg,
		`SELECT id, folder, author, subject, message, expiration, create_at, update_at
			      FROM messages WHERE folder = $1, id = $2`, folder, msgid)
	if err != nil {
		return nil, err
	}
	// TODO: replace _ with rows and check.
	_, err = s.db.Exec(
		"INSERT INTO read (login, folder, msgid) VALUES ($1, $2, $3)",
		login, folder, msgid)

	return msg, err
}
