package folders

import (
	"context"
	"strings"

	"git.lyda.ie/kevin/bulletin/storage"
	"git.lyda.ie/kevin/bulletin/this"
)

// GetUser gets a user.
func GetUser(login string) (*storage.User, error) {
	ctx := context.TODO()
	user, err := this.Q.GetUser(ctx, login)

	return &user, err
}

// AddUser adds a user.
func AddUser(user storage.User) (*storage.User, error) {
	ctx := context.TODO()
	newuser, err := this.Q.AddUser(ctx, storage.AddUserParams{
		Login: strings.ToUpper(user.Login),
		Name:  user.Name,
		Admin: user.Admin,
	})
	return &newuser, err
}

// IsUserAdmin checks if a user is an admin.
func IsUserAdmin(login string) bool {
	ctx := context.TODO()
	found, _ := this.Q.IsUserAdmin(ctx, login)
	return found == 1
}
