// Package key manages the authorized keys file.
package key

import (
	"fmt"
	"os"
	"path"

	"github.com/adrg/xdg"
)

var keytemplate = `command="%s -u %s",no-port-forwarding,no-X11-forwarding,no-agent-forwarding %s\n`

// Add adds an ssh key to the `authorized_keys` file.
func Add(login, public string) error {
	bulletin, err := os.Executable()
	if err != nil {
		return err
	}

	keyline := fmt.Sprintf(keytemplate, bulletin, login, public)

	sshdir := path.Join(xdg.Home, ".ssh")
	err = os.MkdirAll(sshdir, 0700)
	if err != nil {
		return err
	}
	keyfile := path.Join(sshdir, "authorized_keys")

	f, err := os.OpenFile(keyfile, os.O_APPEND|os.O_WRONLY|os.O_CREATE, 0600)
	if err != nil {
		return err
	}
	defer f.Close()
	n, err := f.WriteString(keyline)
	if err != nil {
		return err
	}
	if n != len(keyline) {
		return fmt.Errorf("Failed to write authorized_key fully %d of %d chars written",
			n, len(keyline))
	}

	return nil
}
