/*
Package ask provides routines to ask questions of users. It handles
getting a line of text, getting a choice from a liat and other things.
*/
package ask

import (
	"fmt"
	"os"

	"github.com/chzyer/readline"
)

// CheckErr prints an error message and exits.
func CheckErr(err error) {
	if err != nil {
		fmt.Printf("ERROR: %s\n", err)
		os.Exit(1)
	}
}

// GetLine gets a line.
func GetLine(prompt string) (string, error) {
	rl, err := readline.New(prompt)
	if err != nil {
		return "", err
	}
	defer rl.Close()
	line, err := rl.Readline()
	return line, err
}
