/*
Package this has the current state of the running bulletin process.

Each bulletin process is run by a single user.  The `this` package
tracks the current user state - it has the user login, the current
folder, the current message id and other things.

TODO: Eventually `this` will need to handle broadcast messages.
*/
package this

import (
	"context"
	"errors"
	"fmt"

	"git.lyda.ie/kevin/bulletin/ask"
	"git.lyda.ie/kevin/bulletin/storage"
	"git.lyda.ie/kevin/bulletin/users"
	"github.com/jmoiron/sqlx"
)

// User is the user for this session.
var User storage.User

// Store is the store for this session.
var Store *sqlx.DB

// Q is the storage.Queries for this session.
var Q *storage.Queries

// Folder is the current folder.
var Folder string

// MsgID is the current message id.
var MsgID int64

// StartThis starts a session.
func StartThis(login, name string) error {
	// Validate the login name.
	err := users.ValidLogin(login)
	if err != nil {
		return err
	}

	// Connect to the DB.
	Store, err = storage.Open()
	if err != nil {
		return err
	}
	Q = storage.New(Store.DB)

	ctx := context.TODO()
	User, err = Q.GetUser(ctx, login)

	if User.Login != login {
		if name == "" {
			fmt.Printf("Welcome new user %s\n", login)
			name, err = ask.GetLine("please enter your name: ")
			if err != nil {
				return err
			}
		}

		User, err = Q.AddUser(ctx, storage.AddUserParams{
			Login: login,
			Name:  name,
		})
		if err != nil {
			return err
		}
		fmt.Println("User successfully created. Enjoy!")
	}
	if User.Disabled == 1 {
		return errors.New("User is disabled")
	}
	Folder = "GENERAL"
	MsgID, err = Q.GetFirstMessageID(ctx, Folder)

	return nil
}
