// Package repl implements the main event loop.
package repl

import (
	"errors"
	"fmt"
	"strconv"
	"strings"
	"time"

	"git.lyda.ie/kevin/bulletin/accounts"
	"git.lyda.ie/kevin/bulletin/dclish"
	"git.lyda.ie/kevin/bulletin/editor"
)

// ActionDirectory handles the `DIRECTORY` command.  This lists all the
// messages in the current folder.
func ActionDirectory(cmd *dclish.Command) error {
	// TODO: flag parsing.
	if len(cmd.Args) == 1 {
		if strings.Contains(cmd.Args[0], "%") {
			return errors.New("Folder name cannot contain a %")
		}
		folder := accounts.User.Folders.FindFolder(cmd.Args[0])
		if folder == "" {
			return errors.New("Unable to select the folder")
		}
		if !accounts.User.Folders.IsFolderAccess(folder, accounts.User.Login) {
			// TODO: Should be:
			//       WRITE(6,'('' You are not allowed to access folder.'')')
			//       WRITE(6,'('' See '',A,'' if you wish to access folder.'')')
			return errors.New("Unable to select the folder")
		}
		accounts.User.CurrentFolder = folder
	}
	msgs, err := accounts.User.Folders.ListMessages(
		accounts.User.CurrentFolder, nil)
	if err != nil {
		return err
	}
	if len(msgs) == 0 {
		fmt.Println("There are no messages present.")
		return nil
	}
	fmt.Printf("%4s %-43s %-12s %-10s\n", "#", "Subject", "From", "Date")
	for _, msg := range msgs {
		fmt.Printf("%4d %-43s %-12s %-10s\n", msg.ID, msg.Subject, msg.Author,
			msg.CreateAt.Format("2006-05-04 15:02:01"))
	}

	return nil
}

// ActionAdd handles the `ADD` command.  This adds a message to a folder.
func ActionAdd(cmd *dclish.Command) error {
	optAll := 0
	optBell := 0
	optBroadcast := 0
	optEdit := 0
	optExpiration := &time.Time{}
	optExtract := 0
	optFolder := []string{}
	optIndent := 0
	optPermanent := 0
	optShutdown := 0
	optSignature := 0
	optSubject := ""
	optSystem := 0

	if cmd.Flags["/ALL"].Value == "true" {
		optAll = 1
	}
	if cmd.Flags["/BELL"].Value == "true" {
		optBell = 1
	}
	if cmd.Flags["/BROADCAST"].Value == "true" {
		optBroadcast = 1
	}
	if cmd.Flags["/EDIT"].Value == "true" {
		optEdit = 1
	}
	if cmd.Flags["/EXPIRATION"].Value != "" {
		// dd-mmm-yyyy, or delta time: dddd
		exp, err := time.Parse("2006-01-02", cmd.Flags["/EXPIRATION"].Value)
		if err != nil {
			days, err := strconv.Atoi(cmd.Flags["/EXPIRATION"].Value)
			if err != nil {
				optExpiration = nil
			}
			exp := time.Now().AddDate(0, 0, days)
			optExpiration = &exp
		} else {
			optExpiration = &exp
		}
	}
	if cmd.Flags["/EXTRACT"].Value == "true" {
		optExtract = 1
	}
	if cmd.Flags["/FOLDER"].Value != "" {
		fmt.Printf("/FOLDER = %s\n", cmd.Flags["/FOLDER"].Value)
		optFolder = strings.Split(cmd.Flags["/FOLDER"].Value, ",")
	}
	if cmd.Flags["/INDENT"].Value == "true" {
		optIndent = 1
	}
	if cmd.Flags["/PERMANENT"].Value == "true" {
		optPermanent = 1
	}
	if cmd.Flags["/SHUTDOWN"].Value == "true" {
		optShutdown = 1
	}
	if cmd.Flags["/SIGNATURE"].Value == "true" {
		optSignature = 1
	}
	if cmd.Flags["/SUBJECT"].Value != "" {
		optSubject = cmd.Flags["/SUBJECT"].Value
	}
	if cmd.Flags["/SYSTEM"].Value == "true" {
		optSystem = 1
	}

	fmt.Printf("TODO: optAll is not yet implemented - you set it to %d\n", optAll)
	fmt.Printf("TODO: optBell is not yet implemented - you set it to %d\n", optBell)
	fmt.Printf("TODO: optBroadcast is not yet implemented - you set it to %d\n", optBroadcast)
	fmt.Printf("TODO: optEdit is not yet implemented - you set it to %d\n", optEdit)
	fmt.Printf("TODO: optExtract is not yet implemented - you set it to %d\n", optExtract)
	fmt.Printf("TODO: optIndent is not yet implemented - you set it to %d\n", optIndent)
	fmt.Printf("TODO: optSignature is not yet implemented - you set it to %d\n", optSignature)
	fmt.Printf("TODO: optSystem is not yet implemented - you set it to %d\n", optSystem)

	if len(optFolder) == 0 {
		optFolder = []string{accounts.User.CurrentFolder}
	}
	// TODO: check if folders exist.
	if optSubject == "" {
		optSubject, _ = accounts.GetLine("Enter subject of message: ")
		if optSubject == "" {
			return errors.New("Must enter a subject")
		}
	}
	// TODO: check we have permission for shutdown and permanent

	message, err := editor.Editor(fmt.Sprintf("Enter message for '%s'...", optSubject), "Edit message")
	if err != nil {
		return err
	}
	for i := range optFolder {
		err = accounts.User.Folders.CreateMessage(accounts.User.Login, optSubject, message,
			optFolder[i], optPermanent, optShutdown, optExpiration)
	}
	return nil
}

// ActionCurrent handles the `CURRENT` command.
func ActionCurrent(cmd *dclish.Command) error {
	fmt.Printf("TODO: unimplemented...\n%s\n", cmd.Description)
	return nil
}

// ActionBack handles the `BACK` command.
func ActionBack(cmd *dclish.Command) error {
	fmt.Printf("TODO: unimplemented...\n%s\n", cmd.Description)
	return nil
}

// ActionChange handles the `CHANGE` command.
func ActionChange(cmd *dclish.Command) error {
	fmt.Printf("TODO: unimplemented...\n%s\n", cmd.Description)
	return nil
}

// ActionFirst handles the `FIRST` command.
func ActionFirst(cmd *dclish.Command) error {
	fmt.Printf("TODO: unimplemented...\n%s\n", cmd.Description)
	return nil
}

// ActionNext handles the `NEXT` command.
func ActionNext(cmd *dclish.Command) error {
	fmt.Printf("TODO: unimplemented...\n%s\n", cmd.Description)
	return nil
}

// ActionRead handles the `READ` command.
func ActionRead(cmd *dclish.Command) error {
	// TODO: We need to set accounts.User.CurrentMessage when we change folder.
	msgid := accounts.User.CurrentMessage
	if len(cmd.Args) == 1 {
		var err error
		msgid, err = strconv.Atoi(cmd.Args[0])
		if err != nil {
			return err
		}
	}
	msg, err := accounts.User.Folders.ReadMessage(
		accounts.User.Login, accounts.User.CurrentFolder, msgid)
	if err != nil {
		return err
	}
	// TODO: update accounts.User.CurrentMessage
	fmt.Printf("%s\n", msg)
	return nil
}

// ActionReply handles the `REPLY` command.
func ActionReply(cmd *dclish.Command) error {
	fmt.Printf("TODO: unimplemented...\n%s\n", cmd.Description)
	return nil
}

// ActionForward handles the `FORWARD` command.
func ActionForward(cmd *dclish.Command) error {
	fmt.Printf("TODO: unimplemented...\n%s\n", cmd.Description)
	return nil
}
