// Package repl implements the main event loop.
package repl

import (
	"fmt"

	"github.com/carlmjohnson/versioninfo"

	"git.lyda.ie/kevin/bulletin/dclish"
)

// ActionShowFlags handles the `SHOW FLAGS` command.
func ActionShowFlags(_ *dclish.Command) error {
	fmt.Println("TODO: implement ActionShowFlags.")
	return nil
}

// ActionShowFolder handles the `SHOW FOLDER` command.
func ActionShowFolder(_ *dclish.Command) error {
	fmt.Println("TODO: implement ActionShowFolder.")
	return nil
}

// ActionShowNew handles the `SHOW NEW` command.
func ActionShowNew(_ *dclish.Command) error {
	fmt.Println("TODO: implement ActionShowNew.")
	return nil
}

// ActionShowPrivileges handles the `SHOW PRIVILEGES` command.
func ActionShowPrivileges(_ *dclish.Command) error {
	fmt.Println("TODO: implement ActionShowPrivileges.")
	return nil
}

// ActionShowUser handles the `SHOW USER` command.
func ActionShowUser(_ *dclish.Command) error {
	fmt.Println("TODO: implement ActionShowUser.")
	return nil
}

// ActionShowVersion handles the `SHOW VERSION` command.
func ActionShowVersion(_ *dclish.Command) error {
	rev := versioninfo.Revision
	if len(rev) > 7 {
		rev = rev[len(rev)-7:]
	}
	fmt.Printf("BULLETIN Version 2.0.7g (%s)\n", rev)
	fmt.Printf("Linked on %s\n",
		versioninfo.LastCommit.Format("2006-05-04 15:02:01"))
	return nil
}
