// Package folders are all the routines and sql for managing folders.
package folders

import (
	"errors"
	"fmt"
)

// FolderVisibility is the folder visibility level.
type FolderVisibility string

// Values for FolderVisibility.
const (
	FolderPublic      FolderVisibility = "public"
	FolderSemiPrivate                  = "semi-private"
	FolderPrivate                      = "private"
)

// FolderOptions are a list of folder options.
type FolderOptions struct {
	Always      int
	Brief       int
	Description string
	Notify      int
	Owner       string
	Readnew     int
	Shownew     int
	System      int
	Expire      int
	Visibility  FolderVisibility
}

// CreateFolder creates a new folder.
func (s *Store) CreateFolder(name string, options FolderOptions) error {
	_, err := s.db.Exec(
		`INSERT INTO folders
			(name, always, brief, description, notify, owner, readnew,
			 shownew, system, expire, visibility)
			VALUES
			($1, $2, $3, $4, $5, $6, $7, $8, $9, $10, $11)`,
		name,
		options.Always,
		options.Brief,
		options.Description,
		options.Notify,
		options.Owner,
		options.Readnew,
		options.Shownew,
		options.System,
		options.Expire,
		options.Visibility,
	)
	// TODO: process this error a bit more to give a better error message.
	return err
}

// DeleteFolder creates a new folder.
func (s *Store) DeleteFolder(name string) error {
	results, err := s.db.Exec("DELETE FROM folders WHERE name=$1", name)
	// TODO: process this error a bit more to give a better error message.
	if err != nil {
		return err
	}
	rows, err := results.RowsAffected()
	if err != nil {
		return err
	}
	if rows == 0 {
		return errors.New("No such folder found")
	}
	if rows != 1 {
		return fmt.Errorf("Unexpected number (%d) of folders removed", rows)
	}
	return nil
}
